/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.check;

import org.tukaani.xz.check.Check;

public class CRC64
extends Check {
    private static final long[][] TABLE = new long[4][256];
    private long crc = -1L;

    public CRC64() {
        this.size = 8;
        this.name = "CRC64";
    }

    @Override
    public void update(byte[] bs, int i, int j) {
        int n;
        int n2 = i + j;
        int n3 = n2 - 3;
        for (n = i; n < n3; n += 4) {
            int n4 = (int)this.crc;
            this.crc = TABLE[3][n4 & 0xFF ^ bs[n] & 0xFF] ^ TABLE[2][n4 >>> 8 & 0xFF ^ bs[n + 1] & 0xFF] ^ this.crc >>> 32 ^ TABLE[1][n4 >>> 16 & 0xFF ^ bs[n + 2] & 0xFF] ^ TABLE[0][n4 >>> 24 & 0xFF ^ bs[n + 3] & 0xFF];
        }
        while (n < n2) {
            this.crc = TABLE[0][bs[n++] & 0xFF ^ (int)this.crc & 0xFF] ^ this.crc >>> 8;
        }
    }

    @Override
    public byte[] finish() {
        long l = this.crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.crc = -1L;
        byte[] byArray = new byte[8];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(l >> i * 8);
        }
        return byArray;
    }

    static {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 256; ++j) {
                long l = i == 0 ? (long)j : TABLE[i - 1][j];
                for (int k = 0; k < 8; ++k) {
                    if ((l & 1L) == 1L) {
                        l = l >>> 1 ^ 0xC96C5795D7870F42L;
                        continue;
                    }
                    l >>>= 1;
                }
                CRC64.TABLE[i][j] = l;
            }
        }
    }
}

