/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.updater;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.installer.MarkdownFormatter;
import com.seibel.distanthorizons.core.jar.installer.ModrinthGetter;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.IVersionConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.DhScreen;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.GuiHelper;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import org.apache.logging.log4j.Logger;

public class ChangelogScreen
extends DhScreen {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private class_437 parent;
    private String versionID;
    private List<String> changelog;
    private TextArea changelogArea;
    public boolean usable = false;

    public ChangelogScreen(class_437 parent) {
        this(parent, null);
        if (!ModrinthGetter.initted) {
            ModrinthGetter.init();
        }
        if (!ModrinthGetter.initted) {
            return;
        }
        if (!ModrinthGetter.mcVersions.contains(SingletonInjector.INSTANCE.get(IVersionConstants.class).getMinecraftVersion())) {
            return;
        }
        String versionID = ModrinthGetter.getLatestIDForVersion(SingletonInjector.INSTANCE.get(IVersionConstants.class).getMinecraftVersion());
        if (versionID == null) {
            return;
        }
        try {
            this.setupChangelog(versionID);
            this.usable = true;
        }
        catch (Exception e) {
            LOGGER.error("failed to setup changelog, error: [" + e.getMessage() + "].", (Throwable)e);
        }
    }

    public ChangelogScreen(class_437 parent, String versionID) {
        super((class_2561)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0]));
        this.parent = parent;
        this.versionID = versionID;
        if (versionID == null) {
            return;
        }
        try {
            this.setupChangelog(versionID);
            this.usable = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupChangelog(String versionID) {
        String[] unwrappedChangelog;
        this.changelog = new ArrayList<String>();
        this.changelog.add("\u00a7lChangelog for " + ModrinthGetter.releaseNames.get(versionID) + "\u00a7r");
        this.changelog.add("");
        this.changelog.add("");
        String changelog = ModrinthGetter.changeLogs.get(versionID);
        if (changelog == null) {
            changelog = "";
        }
        for (String str : unwrappedChangelog = new MarkdownFormatter.MinecraftFormat().convertTo(changelog).split("\\n")) {
            this.changelog.addAll(MarkdownFormatter.splitString(str, 75));
        }
    }

    protected void method_25426() {
        super.method_25426();
        if (!this.usable) {
            return;
        }
        this.addBtn(GuiHelper.MakeBtn((class_2561)GuiHelper.Translatable("distanthorizons.general.back", new Object[0]), 5, this.field_22790 - 25, 100, 20, btn -> this.method_25419()));
        this.changelogArea = new TextArea(this.field_22787, this.field_22789 * 2, this.field_22790, 32, 32, 10);
        for (int i = 0; i < this.changelog.size(); ++i) {
            this.changelogArea.addButton((class_2561)GuiHelper.TextOrLiteral(this.changelog.get(i)));
        }
    }

    public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
        double scrollAmount;
        this.method_25420(matrices, mouseX, mouseY, delta);
        if (!this.usable) {
            return;
        }
        int maxScroll = this.changelogArea.method_25331();
        this.changelogArea.field_22749 = scrollAmount = (double)mouseY / (double)this.field_22790 * 1.1 * (double)maxScroll;
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.changelogArea.method_25394(matrices, mouseX, mouseY, delta);
        this.DhDrawCenteredString(matrices, this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
    }

    public void method_25419() {
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    public static class TextArea
    extends class_4265<ButtonEntry> {
        class_327 textRenderer;

        public TextArea(class_310 minecraftClient, int canvasWidth, int canvasHeight, int topMargin, int botMargin, int itemSpacing) {
            super(minecraftClient, canvasWidth, canvasHeight - (topMargin + botMargin), topMargin, itemSpacing);
            this.field_22744 = false;
            this.textRenderer = minecraftClient.field_1772;
        }

        public void addButton(class_2561 text) {
            this.method_25321((class_350.class_351)ButtonEntry.create(text));
        }

        public int method_25322() {
            return 10000;
        }
    }

    public static class ButtonEntry
    extends class_4265.class_4266<ButtonEntry> {
        private static final class_327 textRenderer = class_310.method_1551().field_1772;
        private final class_2561 text;
        private final List<class_339> children = new ArrayList<class_339>();

        private ButtonEntry(class_2561 text) {
            this.text = text;
        }

        public static ButtonEntry create(class_2561 text) {
            return new ButtonEntry(text);
        }

        public void method_25343(class_332 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            matrices.method_27535(textRenderer, this.text, 12, y + 5, 0xFFFFFF);
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }
    }
}

