/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.network.messages.fullData;

import com.google.common.base.MoreObjects;
import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import com.seibel.distanthorizons.core.util.TimerUtil;
import io.netty.buffer.ByteBuf;
import java.util.Timer;

public class FullDataSplitMessage
extends AbstractNetworkMessage {
    private static final long BUFFER_RELEASE_DELAY_MS = 5000L;
    public int bufferId;
    public ByteBuf buffer;
    public boolean isFirst;
    private static final Timer bufferReleaseTimer = TimerUtil.CreateTimer("FullDataBufferCleanupTimer");
    private boolean releaseScheduled = false;

    public FullDataSplitMessage() {
    }

    public FullDataSplitMessage(int bufferId, ByteBuf buffer, boolean isFirst) {
        this.bufferId = bufferId;
        this.buffer = buffer;
        this.isFirst = isFirst;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeInt(this.bufferId);
        out.writeInt(this.buffer.writerIndex());
        out.writeBytes(this.buffer.readerIndex(0));
        out.writeBoolean(this.isFirst);
        if (!this.releaseScheduled) {
            bufferReleaseTimer.schedule(TimerUtil.createTimerTask(() -> ((ByteBuf)this.buffer).release()), 5000L);
            this.releaseScheduled = true;
        }
    }

    @Override
    public void decode(ByteBuf in) {
        this.bufferId = in.readInt();
        int bufferSize = in.readInt();
        this.buffer = in.readBytes(bufferSize);
        this.isFirst = in.readBoolean();
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("bufferId", this.bufferId).add("buffer", (Object)this.buffer).add("isFirst", this.isFirst);
    }
}

