/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.to_client;

import edivad.dimstorage.DimStorage;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncLiquidTank(BlockPos pos, FluidStack fluidStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncLiquidTank> TYPE = new CustomPacketPayload.Type(DimStorage.rl("sync_liquid_tank"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncLiquidTank> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncLiquidTank::pos, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, SyncLiquidTank::fluidStack, SyncLiquidTank::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncLiquidTank message, IPayloadContext ctx) {
        BlockEntity blockEntity;
        Level level = ctx.player().level();
        if (level.isLoaded(message.pos) && (blockEntity = level.getBlockEntity(message.pos)) instanceof BlockEntityDimTank) {
            BlockEntityDimTank tank = (BlockEntityDimTank)blockEntity;
            tank.liquidState.sync(message.fluidStack);
        }
    }
}

