/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import edivad.dimstorage.DimStorage;
import edivad.dimstorage.blockentities.BlockEntityDimChest;
import edivad.dimstorage.setup.Registration;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.joml.Quaternionf;

public class DimChestRenderer
implements BlockEntityRenderer<BlockEntityDimChest> {
    private static final String STATIC = "static";
    public static final ModelLayerLocation STATIC_LAYER = new ModelLayerLocation(Registration.DIMCHEST.getId(), "static");
    private static final String MOVABLE = "movable";
    public static final ModelLayerLocation MOVABLE_LAYER = new ModelLayerLocation(Registration.DIMCHEST.getId(), "movable");
    private static final String GREEN_INDICATOR = "greenIndicator";
    public static final ModelLayerLocation GREEN_INDICATOR_LAYER = new ModelLayerLocation(Registration.DIMCHEST.getId(), "greenIndicator");
    private static final String BLUE_INDICATOR = "blueIndicator";
    public static final ModelLayerLocation BLUE_INDICATOR_LAYER = new ModelLayerLocation(Registration.DIMCHEST.getId(), "blueIndicator");
    private static final String RED_INDICATOR = "redIndicator";
    public static final ModelLayerLocation RED_INDICATOR_LAYER = new ModelLayerLocation(Registration.DIMCHEST.getId(), "redIndicator");
    private static final ResourceLocation TEXTURE = DimStorage.rl("textures/model/dimchest.png");
    private final ModelPart staticLayer;
    private final ModelPart movableLayer;
    private final ModelPart greenIndicatorLayer;
    private final ModelPart blueIndicatorLayer;
    private final ModelPart redIndicatorLayer;

    public DimChestRenderer(BlockEntityRendererProvider.Context context) {
        this.staticLayer = context.bakeLayer(STATIC_LAYER);
        this.movableLayer = context.bakeLayer(MOVABLE_LAYER);
        this.greenIndicatorLayer = context.bakeLayer(GREEN_INDICATOR_LAYER);
        this.blueIndicatorLayer = context.bakeLayer(BLUE_INDICATOR_LAYER);
        this.redIndicatorLayer = context.bakeLayer(RED_INDICATOR_LAYER);
    }

    public static LayerDefinition createStaticLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 16.0f, 13.0f, 16.0f).mirror(true), PartPose.offset((float)-8.0f, (float)11.0f, (float)-8.0f));
        partDefinition.addOrReplaceChild("top1", CubeListBuilder.create().texOffs(66, 2).addBox(0.0f, 0.0f, 0.0f, 16.0f, 3.0f, 2.0f).mirror(true), PartPose.offset((float)-8.0f, (float)8.0f, (float)-8.0f));
        partDefinition.addOrReplaceChild("top2", CubeListBuilder.create().texOffs(0, 32).addBox(0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 14.0f).mirror(true), PartPose.offset((float)6.0f, (float)8.0f, (float)-6.0f));
        partDefinition.addOrReplaceChild("top3", CubeListBuilder.create().texOffs(36, 32).addBox(0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 14.0f).mirror(true), PartPose.offset((float)-8.0f, (float)8.0f, (float)-6.0f));
        partDefinition.addOrReplaceChild("top4", CubeListBuilder.create().texOffs(66, 10).addBox(0.0f, 0.0f, 0.0f, 12.0f, 3.0f, 2.0f).mirror(true), PartPose.offset((float)-6.0f, (float)8.0f, (float)6.0f));
        partDefinition.addOrReplaceChild("top5", CubeListBuilder.create().texOffs(72, 32).addBox(0.0f, 0.0f, 0.0f, 12.0f, 2.0f, 6.0f).mirror(true), PartPose.offset((float)-6.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public static LayerDefinition createMovableLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(MOVABLE, CubeListBuilder.create().texOffs(70, 24).addBox(0.0f, 0.0f, 0.0f, 12.0f, 1.0f, 6.0f).mirror(true), PartPose.offset((float)-6.0f, (float)8.533334f, (float)-6.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public static LayerDefinition createIndicatorLayer(int offsetY) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(MOVABLE, CubeListBuilder.create().texOffs(0, offsetY).addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f).mirror(true), PartPose.offset((float)-5.0f, (float)7.5f, (float)4.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public void render(BlockEntityDimChest blockentity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (blockentity.isRemoved()) {
            return;
        }
        poseStack.pushPose();
        this.renderBlock(blockentity, partialTicks, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        poseStack.popPose();
    }

    private void renderBlock(BlockEntityDimChest blockentity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.pushPose();
        poseStack.translate(0.5, -0.5, 0.5);
        poseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, (float)(360 - blockentity.rotation * 90) * ((float)Math.PI / 180), 0.0f));
        poseStack.mulPose(new Quaternionf().rotationXYZ((float)Math.PI, 0.0f, 0.0f));
        poseStack.translate(0.0, -2.0, 0.0);
        VertexConsumer buffer = bufferIn.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE));
        int color = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.staticLayer.render(poseStack, buffer, combinedLightIn, combinedOverlayIn, color);
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, blockentity.movablePartState);
        this.movableLayer.render(poseStack, buffer, combinedLightIn, combinedOverlayIn, color);
        poseStack.popPose();
        if (blockentity.locked) {
            this.redIndicatorLayer.render(poseStack, buffer, combinedLightIn, combinedOverlayIn, color);
        } else if (blockentity.getFrequency().hasOwner()) {
            this.blueIndicatorLayer.render(poseStack, buffer, combinedLightIn, combinedOverlayIn, color);
        } else {
            this.greenIndicatorLayer.render(poseStack, buffer, combinedLightIn, combinedOverlayIn, color);
        }
        poseStack.popPose();
    }
}

