/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.api;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.Nullable;

public record Frequency(Optional<GameProfile> gameProfile, int channel) implements TooltipProvider
{
    public static final Codec<Frequency> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.GAME_PROFILE.optionalFieldOf("gameProfile").forGetter(Frequency::gameProfile), (App)Codec.INT.fieldOf("channel").forGetter(Frequency::channel)).apply((Applicative)instance, Frequency::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Frequency> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.GAME_PROFILE), frequency -> frequency.gameProfile, (StreamCodec)ByteBufCodecs.INT, frequency -> frequency.channel, Frequency::new);

    public Frequency() {
        this(1);
    }

    public Frequency(int channel) {
        this((Player)null, channel);
    }

    public Frequency(@Nullable Player player, int channel) {
        this(Optional.ofNullable(player).map(Player::getGameProfile), channel);
    }

    public Frequency setPublic() {
        return new Frequency(Optional.empty(), this.channel);
    }

    public Frequency setOwner(Player player) {
        return new Frequency(player, this.channel);
    }

    public Frequency setChannel(int channel) {
        return new Frequency(this.gameProfile, channel);
    }

    public boolean hasOwner() {
        return this.gameProfile.isPresent();
    }

    public boolean canAccess(Player player) {
        return this.gameProfile.map(profile -> profile.equals((Object)player.getGameProfile())).orElse(true);
    }

    public String getOwner() {
        return this.gameProfile().map(GameProfile::getName).orElse("public");
    }

    @Override
    public String toString() {
        return "gameProfile=" + String.valueOf(this.hasOwner() ? this.gameProfile.get().getId() : "public") + ",channel=" + this.channel;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.gameProfile.ifPresent(profile -> {
            tag.putUUID("gameProfile", profile.getId());
            tag.putString("ownerName", profile.getName());
        });
        tag.putInt("channel", this.channel);
        return tag;
    }

    public static Frequency deserializeNBT(CompoundTag tag) {
        if (tag.contains("gameProfile") && tag.contains("ownerName")) {
            GameProfile owner = new GameProfile(tag.getUUID("gameProfile"), tag.getString("ownerName"));
            return new Frequency(Optional.of(owner), tag.getInt("channel"));
        }
        return new Frequency(Optional.empty(), tag.getInt("channel"));
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> consumer, TooltipFlag flag) {
        if (this.hasOwner()) {
            consumer.accept((Component)Component.translatable((String)"gui.dimstorage.owner").append(" " + this.getOwner()).withStyle(ChatFormatting.DARK_RED));
        }
        consumer.accept((Component)Component.translatable((String)"gui.dimstorage.frequency").append(" " + this.channel()));
    }
}

