/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.data;

import dev.corgitaco.dataanchor.data.ClientTrackedData;
import dev.corgitaco.dataanchor.data.ServerTrackedData;
import dev.corgitaco.dataanchor.data.TrackedData;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistry;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface TrackedDataContainer<O, T extends TrackedData<O>> {
    public <E extends T> Optional<E> dataAnchor$getTrackedData(TrackedDataKey<E> var1);

    public void dataAnchor$createTrackedData();

    public Collection<TrackedDataKey<T>> dataAnchor$getTrackedDataKeys();

    public static <O, T extends TrackedData<O>> TrackedDataContainer<O, T> makeBasicContainer(TrackedDataRegistry<O, T> registry, O o, boolean isClient) {
        return TrackedDataContainer.makeBasicContainer(registry, o, isClient, false);
    }

    public static <O, T extends TrackedData<O>> TrackedDataContainer<O, T> makeBasicContainer(final TrackedDataRegistry<O, T> registry, final O o, final boolean isClient, final boolean lazyLoad) {
        return new TrackedDataContainer<O, T>(){
            private boolean lazyLoaded;
            private final Map<TrackedDataKey<T>, T> trackedDataMap;
            private final List<TrackedDataKey<T>> keys;
            {
                this.lazyLoaded = !lazyLoad;
                this.trackedDataMap = new Reference2ReferenceOpenHashMap();
                this.keys = List.copyOf(registry.factories().keySet());
            }

            @Override
            public <E extends T> Optional<E> dataAnchor$getTrackedData(TrackedDataKey<E> key) {
                TrackedData t;
                if (!this.lazyLoaded) {
                    this.dataAnchor$createTrackedData();
                    this.lazyLoaded = true;
                }
                if ((t = (TrackedData)this.trackedDataMap.get(key)) == null) {
                    return Optional.empty();
                }
                return Optional.of(t);
            }

            @Override
            public void dataAnchor$createTrackedData() {
                registry.factories().forEach((key, factory) -> {
                    Object trackedData = factory.create(key, o);
                    if (trackedData != null) {
                        if (isClient) {
                            if (trackedData instanceof ClientTrackedData) {
                                this.trackedDataMap.put((TrackedDataKey)key, (Object)trackedData);
                            }
                        } else if (trackedData instanceof ServerTrackedData) {
                            this.trackedDataMap.put((TrackedDataKey)key, (Object)trackedData);
                        }
                    }
                });
            }

            @Override
            public Collection<TrackedDataKey<T>> dataAnchor$getTrackedDataKeys() {
                if (!this.lazyLoaded) {
                    this.dataAnchor$createTrackedData();
                    this.lazyLoaded = true;
                }
                return this.keys;
            }
        };
    }
}

