/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item;

import com.blakebr0.cucumber.init.ModDataComponentTypes;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.cucumber.util.WateringCanUtil;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.FakePlayer;

public class BaseWateringCanItem
extends BaseItem {
    protected final int range;
    protected final double chance;

    public BaseWateringCanItem(int range, double chance) {
        this(range, chance, p -> p);
    }

    public BaseWateringCanItem(int range, double chance, Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.stacksTo(1).component(ModDataComponentTypes.WATERING_CAN_FILLED, (Object)false)));
        this.range = range;
        this.chance = chance;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 200;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        FluidState fluid;
        ItemStack stack = player.getItemInHand(hand);
        if (BaseWateringCanItem.isFilled(stack)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BlockHitResult trace = BaseWateringCanItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (trace.getType() != HitResult.Type.BLOCK) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BlockPos pos = trace.getBlockPos();
        Direction direction = trace.getDirection();
        if (level.mayInteract(player, pos) && player.mayUseItemAt(pos.relative(direction), direction, stack) && (fluid = level.getFluidState(pos)).is(FluidTags.WATER)) {
            BaseWateringCanItem.setFilled(stack, true);
            player.playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction direction;
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        InteractionHand hand = context.getHand();
        ItemStack stack = player.getItemInHand(hand);
        BlockPos pos = context.getClickedPos();
        if (!player.mayUseItemAt(pos.relative(direction = context.getClickedFace()), direction, stack)) {
            return InteractionResult.FAIL;
        }
        if (!BaseWateringCanItem.isFilled(stack)) {
            return InteractionResult.PASS;
        }
        player.startUsingItem(hand);
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        if (player instanceof FakePlayer) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            Direction direction = context.getClickedFace();
            return this.doWater(stack, level, player, pos, direction);
        }
        return InteractionResult.PASS;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingTicks) {
        if (remainingTicks >= 0 && entity instanceof Player) {
            Player player = (Player)entity;
            BlockHitResult trace = BaseWateringCanItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            if (trace.getType() == HitResult.Type.BLOCK) {
                this.doWater(stack, level, player, trace.getBlockPos(), trace.getDirection());
            } else {
                entity.releaseUsingItem();
            }
        } else {
            entity.releaseUsingItem();
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (BaseWateringCanItem.isFilled(stack)) {
            tooltip.add((Component)Tooltips.FILLED.build());
        } else {
            tooltip.add((Component)Tooltips.EMPTY.build());
        }
    }

    public static boolean isFilled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponentTypes.WATERING_CAN_FILLED, (Object)false);
    }

    public static void setFilled(ItemStack stack, boolean filled) {
        stack.set(ModDataComponentTypes.WATERING_CAN_FILLED, (Object)filled);
    }

    protected InteractionResult doWater(ItemStack stack, Level level, Player player, BlockPos pos, Direction direction) {
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (!player.mayUseItemAt(pos.relative(direction), direction, stack)) {
            return InteractionResult.FAIL;
        }
        if (!BaseWateringCanItem.isFilled(stack)) {
            return InteractionResult.FAIL;
        }
        if (!this.allowFakePlayerWatering() && player instanceof FakePlayer) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide()) {
            Item item;
            ItemCooldowns cooldowns = player.getCooldowns();
            if (!cooldowns.isOnCooldown(item = stack.getItem())) {
                cooldowns.addCooldown(item, BaseWateringCanItem.getThrottleTicks(player));
            } else {
                return InteractionResult.FAIL;
            }
        }
        int range = (this.range - 1) / 2;
        BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)).forEach(aoePos -> {
            int moisture;
            BlockState aoeState = level.getBlockState(aoePos);
            if (aoeState.getBlock() instanceof FarmBlock && (moisture = ((Integer)aoeState.getValue((Property)FarmBlock.MOISTURE)).intValue()) < 7) {
                level.setBlock(aoePos, (BlockState)aoeState.setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7)), 3);
            }
        });
        RandomSource random = Utils.RANDOM;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                double d0 = (float)pos.offset(x, 0, z).getX() + random.nextFloat();
                double d1 = (double)pos.offset(x, 0, z).getY() + 1.0;
                double d2 = (float)pos.offset(x, 0, z).getZ() + random.nextFloat();
                BlockState state = level.getBlockState(pos);
                if (state.canOcclude() || state.getBlock() instanceof FarmBlock) {
                    d1 += 0.3;
                }
                level.addParticle((ParticleOptions)ParticleTypes.RAIN, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
        BaseWateringCanItem.startPlayingSound(player);
        if (!level.isClientSide() && Math.random() <= this.chance) {
            BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)).forEach(aoePos -> {
                BlockState state = level.getBlockState(aoePos);
                Block plantBlock = state.getBlock();
                if (plantBlock instanceof BonemealableBlock || plantBlock == Blocks.MYCELIUM || plantBlock == Blocks.CHORUS_FLOWER) {
                    state.randomTick((ServerLevel)level, aoePos, random);
                }
            });
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    protected boolean allowFakePlayerWatering() {
        return true;
    }

    public static void startPlayingSound(Player player) {
        if (player.level().isClientSide()) {
            WateringCanUtil.startPlayingSound(player);
        }
    }

    public static void stopPlayingSound(Player player) {
        if (player.level().isClientSide()) {
            WateringCanUtil.stopPlayingSound(player);
        }
    }

    private static int getThrottleTicks(Player player) {
        return player instanceof FakePlayer ? 10 : 5;
    }
}

