/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import net.minecraft.world.item.ItemStack;

public final class StackHelper {
    public static ItemStack withSize(ItemStack stack, int size, boolean container) {
        if (size <= 0) {
            if (container && stack.hasCraftingRemainingItem()) {
                return stack.getCraftingRemainingItem();
            }
            return ItemStack.EMPTY;
        }
        stack = stack.copy();
        stack.setCount(size);
        return stack;
    }

    public static ItemStack grow(ItemStack stack, int amount) {
        return StackHelper.withSize(stack, stack.getCount() + amount, false);
    }

    public static ItemStack shrink(ItemStack stack, int amount, boolean container) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return StackHelper.withSize(stack, stack.getCount() - amount, container);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty() && stack2.isEmpty()) {
            return true;
        }
        return !stack1.isEmpty() && ItemStack.isSameItem((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return StackHelper.areItemsEqual(stack1, stack2) && ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean canCombineStacks(ItemStack stack1, ItemStack stack2) {
        if (!stack1.isEmpty() && stack2.isEmpty()) {
            return true;
        }
        return StackHelper.areStacksEqual(stack1, stack2) && stack1.getCount() + stack2.getCount() <= stack1.getMaxStackSize();
    }

    public static ItemStack combineStacks(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty()) {
            return stack2.copy();
        }
        return StackHelper.grow(stack1, stack2.getCount());
    }
}

