/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.client.handler;

import com.blakebr0.cucumber.config.ModConfigs;
import com.blakebr0.cucumber.lib.Tooltips;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public final class DataComponentTooltipHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (!((Boolean)ModConfigs.ENABLE_DATA_COMPONENT_TOOLTIPS.get()).booleanValue()) {
            return;
        }
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            ItemStack stack = event.getItemStack();
            DataComponentMap components = stack.getComponents();
            List tooltip = event.getToolTip();
            if (Screen.hasAltDown()) {
                tooltip.add(Tooltips.DATA_COMPONENTS.build());
                for (TypedDataComponent component : components) {
                    tooltip.add(DataComponentTooltipHandler.createTextComponent(component));
                }
            } else {
                tooltip.add(Tooltips.HOLD_ALT_FOR_DATA_COMPONENTS.build());
            }
        }
    }

    private static Component createTextComponent(TypedDataComponent<?> component) {
        String text = " " + StringUtil.truncateStringIfNecessary((String)component.toString(), (int)50, (boolean)true);
        return Component.literal((String)text).withStyle(ChatFormatting.DARK_GRAY);
    }
}

