/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.vec;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3f;
import team.creative.creativecore.common.util.math.base.Axis;

public class VectorUtils {
    public static Vector3d set(Vector3d vec, double value, Axis axis) {
        switch (axis) {
            case X: {
                new Vector3d(value, vec.y, vec.z);
                break;
            }
            case Y: {
                new Vector3d(vec.x, value, vec.z);
                break;
            }
            case Z: {
                new Vector3d(vec.x, vec.y, value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Vec3 set(Vec3 vec, double value, Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> new Vec3(value, vec.y, vec.z);
            case Axis.Y -> new Vec3(vec.x, value, vec.z);
            case Axis.Z -> new Vec3(vec.x, vec.y, value);
        };
    }

    public static void set(BlockPos.MutableBlockPos vec, int value, Axis axis) {
        switch (axis) {
            case X: {
                vec.setX(value);
                break;
            }
            case Y: {
                vec.setY(value);
                break;
            }
            case Z: {
                vec.setZ(value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Vec3i set(Vec3i vec, int value, Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> new Vec3i(value, vec.getY(), vec.getZ());
            case Axis.Y -> new Vec3i(vec.getX(), value, vec.getZ());
            case Axis.Z -> new Vec3i(vec.getX(), vec.getY(), value);
        };
    }

    public static BlockPos set(BlockPos vec, int value, Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> new BlockPos(value, vec.getY(), vec.getZ());
            case Axis.Y -> new BlockPos(vec.getX(), value, vec.getZ());
            case Axis.Z -> new BlockPos(vec.getX(), vec.getY(), value);
        };
    }

    public static double get(Axis axis, Vector3d vec) {
        return VectorUtils.get(axis, vec.x, vec.y, vec.z);
    }

    public static double get(Axis axis, Vec3 vec) {
        return VectorUtils.get(axis, vec.x, vec.y, vec.z);
    }

    public static double get(Direction.Axis axis, Vec3 vec) {
        return VectorUtils.get(axis, vec.x, vec.y, vec.z);
    }

    public static float get(Axis axis, Vector3f vec) {
        return VectorUtils.get(axis, vec.x(), vec.y(), vec.z());
    }

    public static int get(Axis axis, Vec3i vec) {
        return VectorUtils.get(axis, vec.getX(), vec.getY(), vec.getZ());
    }

    public static float get(Axis axis, float x, float y, float z) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> x;
            case Axis.Y -> y;
            case Axis.Z -> z;
        };
    }

    public static double get(Axis axis, double x, double y, double z) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> x;
            case Axis.Y -> y;
            case Axis.Z -> z;
        };
    }

    public static int get(Axis axis, int x, int y, int z) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> x;
            case Axis.Y -> y;
            case Axis.Z -> z;
        };
    }

    public static float get(Direction.Axis axis, float x, float y, float z) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> x;
            case Direction.Axis.Y -> y;
            case Direction.Axis.Z -> z;
        };
    }

    public static double get(Direction.Axis axis, double x, double y, double z) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> x;
            case Direction.Axis.Y -> y;
            case Direction.Axis.Z -> z;
        };
    }

    public static int get(Direction.Axis axis, int x, int y, int z) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> x;
            case Direction.Axis.Y -> y;
            case Direction.Axis.Z -> z;
        };
    }

    public static boolean isZero(double number) {
        return number > (double)-1.0E-4f && number < (double)1.0E-4f;
    }

    public static boolean isZero(float number) {
        return number > -1.0E-4f && number < 1.0E-4f;
    }

    public static boolean equals(double number, double number2) {
        return number - number2 > (double)-1.0E-4f && number - number2 < (double)1.0E-4f;
    }

    public static boolean equals(float number, float number2) {
        return number - number2 > -1.0E-4f && number - number2 < 1.0E-4f;
    }

    public static boolean greaterEquals(float number, float number2) {
        return number > number2 || number - number2 > -1.0E-4f && number - number2 < 1.0E-4f;
    }

    public static boolean smallerEquals(float number, float number2) {
        return number < number2 || number - number2 > -1.0E-4f && number - number2 < 1.0E-4f;
    }

    public static boolean greaterEquals(double number, double number2) {
        return number > number2 || number - number2 > (double)-1.0E-4f && number - number2 < (double)1.0E-4f;
    }

    public static boolean smallerEquals(double number, double number2) {
        return number < number2 || number - number2 > (double)-1.0E-4f && number - number2 < (double)1.0E-4f;
    }
}

