/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils.liquidblazeburners;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.utils.liquidblazeburners.LiquidBlazeBurnerManager;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.WithConditions;

public class LiquidBlazeBurnerReloadListener
extends SimpleJsonResourceReloadListener {
    public static final String FLUID_KEY = "fluid";
    public static final String BURN_TIME_KEY = "burn_time";
    public static final int DEFAULT_BURN_TIME = 20;
    public static final String SUPER_HEATED_KEY = "super_heat";
    public static final String CONSUMPTION_KEY = "consumptionPerTick";
    public static final int DEFAULT_CONSUMPTION = 1;
    public static final LiquidBlazeBurnerReloadListener INSTANCE = new LiquidBlazeBurnerReloadListener();

    public LiquidBlazeBurnerReloadListener() {
        super(new Gson(), "blaze_burner_liquids");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller filler) {
        LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.clear();
        CreateQOL.LOGGER.info("Reloading Liquids for Blaze Burner...");
        ConditionalOps registryops = this.makeConditionalOps();
        jsons.forEach((arg_0, arg_1) -> LiquidBlazeBurnerReloadListener.lambda$apply$2((RegistryOps)registryops, arg_0, arg_1));
        CreateQOL.LOGGER.info("Liquids for Blaze Burner Reloaded, found {} liquids.", (Object)LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.size());
    }

    private static /* synthetic */ void lambda$apply$2(RegistryOps registryops, ResourceLocation rs, JsonElement el) {
        try {
            if (!el.isJsonObject()) {
                throw new RuntimeException(rs.getPath() + " doesn't contain a json object as root");
            }
            JsonObject json = el.getAsJsonObject();
            Optional decoded = (Optional)Entry.CONDITIONAL_CODEC.parse((DynamicOps)registryops, (Object)json).getOrThrow(JsonParseException::new);
            decoded.ifPresentOrElse(e -> {
                Entry entry = (Entry)e.carrier();
                if (LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.containsKey(entry.fluid)) {
                    throw new RuntimeException("Fluid " + String.valueOf(entry.fluid) + " is registered for blaze burners in two different files");
                }
                entry.registerToMap();
            }, () -> CreateQOL.LOGGER.debug("Skipping loading blaze burner liquid {} as its conditions were not met", (Object)rs));
        }
        catch (JsonParseException | IllegalArgumentException exception) {
            CreateQOL.LOGGER.error("Parsing error loading blaze burner liquid {}", (Object)rs, (Object)exception);
        }
    }

    private record Entry(Fluid fluid, int burnTime, boolean superHeat, int consumption) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.FLUID.byNameCodec().fieldOf(LiquidBlazeBurnerReloadListener.FLUID_KEY).forGetter(Entry::fluid), (App)Codec.INT.optionalFieldOf(LiquidBlazeBurnerReloadListener.BURN_TIME_KEY, (Object)20).forGetter(Entry::burnTime), (App)Codec.BOOL.optionalFieldOf(LiquidBlazeBurnerReloadListener.SUPER_HEATED_KEY, (Object)false).forGetter(Entry::superHeat), (App)Codec.INT.optionalFieldOf(LiquidBlazeBurnerReloadListener.CONSUMPTION_KEY, (Object)1).forGetter(Entry::consumption)).apply((Applicative)instance, Entry::new));
        public static final Codec<Optional<WithConditions<Entry>>> CONDITIONAL_CODEC = ConditionalOps.createConditionalCodecWithConditions(CODEC);

        public void registerToMap() {
            LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.put(this.fluid, new LiquidBlazeBurnerManager.LiquidEntry(this.burnTime, this.superHeat, this.consumption));
        }
    }
}

