/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.statue.animation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Rotations;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class StatuePartTable {
    public static final Codec<StatuePartTable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("xRot").forGetter(StatuePartTable::getXRot), (App)Codec.FLOAT.fieldOf("yRot").forGetter(StatuePartTable::getYRot), (App)Codec.FLOAT.fieldOf("zRot").forGetter(StatuePartTable::getZRot)).apply((Applicative)instance, StatuePartTable::new));
    public static final StreamCodec<FriendlyByteBuf, StatuePartTable> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, StatuePartTable>(){

        public StatuePartTable decode(FriendlyByteBuf buf) {
            float x = buf.readFloat();
            float y = buf.readFloat();
            float z = buf.readFloat();
            return new StatuePartTable(x, y, z);
        }

        public void encode(FriendlyByteBuf buf, StatuePartTable table) {
            buf.writeFloat(table.getXRot());
            buf.writeFloat(table.getYRot());
            buf.writeFloat(table.getZRot());
        }
    };
    private final float xRot;
    private final float yRot;
    private final float zRot;

    public StatuePartTable(float xRot, float yRot, float zRot) {
        this.xRot = xRot;
        this.yRot = yRot;
        this.zRot = zRot;
    }

    public StatuePartTable() {
        this(0.0f, 0.0f, 0.0f);
    }

    public float getXRot() {
        return this.xRot;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getZRot() {
        return this.zRot;
    }

    public Rotations toRotation() {
        return new Rotations(this.getXRot(), this.getYRot(), this.getZRot());
    }
}

