/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import fr.iglee42.createqualityoflife.registries.ModDataComponents;
import fr.iglee42.createqualityoflife.registries.ModPackets;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.PreferredRender;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ChangeArmorComponentPacket
implements ServerboundPacketPayload {
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeArmorComponentPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.slot, (StreamCodec)ByteBufCodecs.INT, p -> p.value, (StreamCodec)ByteBufCodecs.STRING_UTF8, p -> p.componentId, ChangeArmorComponentPacket::new);
    private int slot;
    private int value;
    private String componentId;

    public ChangeArmorComponentPacket(int slot, int value, String componentId) {
        this.slot = slot;
        this.value = value;
        this.componentId = componentId;
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return ModPackets.CHANGE_ARMOR_COMPONENT;
    }

    public void handle(ServerPlayer player) {
        DataComponentType component = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.parse((String)this.componentId));
        if (component == null) {
            return;
        }
        if (component.equals(ModDataComponents.ARMOR_EFFECT)) {
            player.getInventory().getArmor(this.slot).set(ModDataComponents.ARMOR_EFFECT, (Object)(this.value != 0 ? 1 : 0));
        } else if (component.equals(ModDataComponents.BACKTANK_FANS)) {
            player.getInventory().getArmor(this.slot).set(ModDataComponents.BACKTANK_FANS, (Object)(this.value != 0 ? 1 : 0));
        } else if (component.equals(ModDataComponents.BACKTANK_HOVER)) {
            player.getInventory().getArmor(this.slot).set(ModDataComponents.BACKTANK_HOVER, (Object)(this.value != 0 ? 1 : 0));
        } else if (component.equals(ModDataComponents.BACKTANK_ELYTRA_STATE)) {
            player.getInventory().getArmor(this.slot).set(ModDataComponents.BACKTANK_ELYTRA_STATE, (Object)(this.value != 0 ? 1 : 0));
        } else if (component.equals(ModDataComponents.BOOTS_BELT)) {
            player.getInventory().getArmor(this.slot).set(ModDataComponents.BOOTS_BELT, (Object)(this.value != 0 ? 1 : 0));
        } else if (component.equals(ModDataComponents.BOOTS_DIVING)) {
            player.getInventory().getArmor(this.slot).set(ModDataComponents.BOOTS_DIVING, (Object)(this.value != 0 ? 1 : 0));
        } else if (component.equals(ModDataComponents.BOOTS_LAVA)) {
            player.getInventory().getArmor(this.slot).set(ModDataComponents.BOOTS_LAVA, (Object)(this.value != 0 ? 1 : 0));
        } else if (component.equals(ModDataComponents.HELMET_GOGGLES)) {
            player.getInventory().getArmor(this.slot).set(ModDataComponents.HELMET_GOGGLES, (Object)(this.value != 0 ? 1 : 0));
        } else if (component.equals(ModDataComponents.ARMOR_RENDER_TYPE)) {
            player.getInventory().getArmor(this.slot).set(ModDataComponents.ARMOR_RENDER_TYPE, (Object)ArmorRenderType.BY_ID.apply(this.value));
        } else if (component.equals(ModDataComponents.PREFERRED_RENDER)) {
            player.getInventory().getArmor(this.slot).set(ModDataComponents.PREFERRED_RENDER, (Object)PreferredRender.BY_ID.apply(this.value));
        }
    }
}

