/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.mixins.liquidblazeburners;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.utils.Features;
import fr.iglee42.createqualityoflife.utils.IHaveTankMixin;
import fr.iglee42.createqualityoflife.utils.liquidblazeburners.LiquidBlazeBurnerManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlazeBurnerBlockEntity.class}, remap=false)
public abstract class BlazeBurnerBlockEntityMixin
implements IHaveTankMixin {
    @Shadow
    protected int remainingBurnTime;
    @Shadow
    protected BlazeBurnerBlockEntity.FuelType activeFuel;
    @Unique
    protected SmartFluidTank createQOL$tank;

    @Shadow
    protected abstract void setBlockHeat(BlazeBurnerBlock.HeatLevel var1);

    @Shadow
    public abstract int getRemainingBurnTime();

    @Shadow
    protected abstract void playSound();

    @Shadow
    public abstract void updateBlockState();

    @Shadow
    public abstract BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock();

    @Shadow
    public abstract void spawnParticleBurst(boolean var1);

    @Inject(method={"addBehaviours"}, at={@At(value="TAIL")})
    private void createQOL$addTank(List<BlockEntityBehaviour> behaviours, CallbackInfo ci) {
        this.createQOL$tank = new SmartFluidTank(this, 1000, stack -> {}){

            public boolean isFluidValid(FluidStack stack) {
                return LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.containsKey(stack.getFluid());
            }
        };
    }

    @Override
    public SmartFluidTank createQOL$tank() {
        return this.createQOL$tank;
    }

    @Inject(method={"read"}, at={@At(value="TAIL")})
    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        if (this.createQOL$tank != null && nbt.contains("tank")) {
            this.createQOL$tank.readFromNBT(registries, nbt.getCompound("tank"));
        }
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        if (this.createQOL$tank != null) {
            nbt.put("tank", (Tag)this.createQOL$tank.writeToNBT(registries, new CompoundTag()));
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo info) {
        if (!CreateQOL.isActivate(Features.LIQUID_BLAZE_BURNER)) {
            return;
        }
        if (this.createQOL$tank == null) {
            return;
        }
        if (this.createQOL$tank.getFluid().getAmount() <= 0) {
            return;
        }
        LiquidBlazeBurnerManager.LiquidEntry fluidProperties = LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.getOrDefault(this.createQOL$tank.getFluid().getFluid(), null);
        if (fluidProperties == null) {
            return;
        }
        boolean superHeated = fluidProperties.superHeated();
        int consumption = fluidProperties.consumption();
        if (this.createQOL$tank.getFluid().getAmount() < consumption) {
            return;
        }
        if (superHeated) {
            this.setBlockHeat(BlazeBurnerBlock.HeatLevel.SEETHING);
        } else {
            this.setBlockHeat(BlazeBurnerBlock.HeatLevel.FADING);
        }
        int newBurnTime = this.getRemainingBurnTime() + fluidProperties.burnTime();
        if (newBurnTime > 10000) {
            return;
        }
        this.remainingBurnTime = newBurnTime;
        this.createQOL$tank.drain(consumption, IFluidHandler.FluidAction.EXECUTE);
    }

    @Inject(method={"tryUpdateFuel"}, at={@At(value="HEAD")}, cancellable=true)
    public void tryUpdateFuel(ItemStack itemStack, boolean forceOverflow, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        BlazeBurnerBlockEntity be;
        Level level;
        if (!CreateQOL.isActivate(Features.LIQUID_BLAZE_BURNER)) {
            return;
        }
        if (this.createQOL$tank == null) {
            return;
        }
        if (itemStack.getCapability(Capabilities.FluidHandler.ITEM) == null) {
            return;
        }
        IFluidHandler handler = (IFluidHandler)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return;
        }
        if (!this.createQOL$tank.getFluid().isEmpty() && handler.getFluidInTank(0).getFluid() != this.createQOL$tank.getFluid().getFluid()) {
            return;
        }
        if (handler.getTanks() != 1) {
            return;
        }
        FluidStack fluidStack = handler.getFluidInTank(0);
        if (fluidStack.isEmpty()) {
            return;
        }
        if (!LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.containsKey(fluidStack.getFluid())) {
            return;
        }
        if (this.createQOL$tank.getFluid().getAmount() + fluidStack.getAmount() > this.createQOL$tank.getCapacity() && !forceOverflow) {
            return;
        }
        if (!simulate) {
            if (this.createQOL$tank.getFluid().isEmpty()) {
                this.createQOL$tank.setFluid(fluidStack.copy());
            } else {
                this.createQOL$tank.getFluid().grow(fluidStack.getAmount());
            }
        }
        if ((level = (be = (BlazeBurnerBlockEntity)this).getLevel()) == null) {
            cir.setReturnValue((Object)true);
            return;
        }
        BlockPos worldPosition = be.getBlockPos();
        if (level.isClientSide) {
            this.spawnParticleBurst(this.activeFuel == BlazeBurnerBlockEntity.FuelType.SPECIAL);
            cir.setReturnValue((Object)true);
        }
        BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (prev != this.getHeatLevelFromBlock()) {
            level.playSound(null, worldPosition, SoundEvents.BLAZE_AMBIENT, SoundSource.BLOCKS, 0.125f + level.random.nextFloat() * 0.125f, 1.15f - level.random.nextFloat() * 0.25f);
        }
        cir.setReturnValue((Object)true);
    }
}

