/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items;

import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.ModDataComponents;
import fr.iglee42.createqualityoflife.utils.CommonKeysHandler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShadowRadianceChestplate
extends BacktankItem.Layered {
    private static final double FANS_ACCELERATION = 0.15;
    private static final double FANS_SPEED = 0.25;
    private static final double FANS_HOVER_SPEED = 0.2;

    public ShadowRadianceChestplate(Holder<ArmorMaterial> material, Item.Properties properties, ResourceLocation textureLoc, Supplier<BacktankItem.BacktankBlockItem> placeable) {
        super(material, properties, textureLoc, placeable);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)("armor." + this.type.getName()));
        return super.getDefaultAttributeModifiers().withModifierAdded(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(resourcelocation, 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot())).withModifierAdded(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(resourcelocation, 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot()));
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ShadowRadianceChestplate.hasElytra(stack) && ShadowRadianceChestplate.isElytraEnable(stack) && (!ShadowRadianceChestplate.hasPropeller(stack) || !ShadowRadianceChestplate.isFansEnable(stack)) && !BacktankUtil.getAllWithAir((LivingEntity)entity).isEmpty() && (Boolean)CreateQOLConfigs.server().elytraAllowed.get() != false;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return true;
    }

    private static boolean hasPlayerStackInInventory(Player player, Item item) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack currentStack = player.getInventory().getItem(i);
            if (currentStack.isEmpty() || !currentStack.is(item)) continue;
            return true;
        }
        return false;
    }

    private static int getFirstInventoryIndex(Player player, Item item) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack currentStack = player.getInventory().getItem(i);
            if (currentStack.isEmpty() || !currentStack.is(item)) continue;
            return i;
        }
        return -1;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.inventoryTick(stack, level, entity, slot, offHand);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.getItemBySlot(EquipmentSlot.CHEST).equals(stack)) {
            boolean second;
            boolean bl = second = level.getGameTime() % 20L == 0L;
            if (BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty()) {
                return;
            }
            if (((Boolean)stack.getOrDefault(ModDataComponents.ARMOR_EFFECT, (Object)true)).booleanValue() && ((Boolean)CreateQOLConfigs.server().armorEffects.get()).booleanValue()) {
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 20, 1, false, false));
            }
            if (player.isFallFlying() && ShadowRadianceChestplate.isElytraEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty() && ((Boolean)CreateQOLConfigs.server().elytraAllowed.get()).booleanValue() && ((Boolean)CreateQOLConfigs.server().elytraBoostAllowed.get()).booleanValue() && CommonKeysHandler.isHoldingUp(player)) {
                if (((Boolean)CreateQOLConfigs.server().useFireworksForBoost.get()).booleanValue()) {
                    if (ShadowRadianceChestplate.hasPlayerStackInInventory(player, Items.FIREWORK_ROCKET)) {
                        int rocketSlot = ShadowRadianceChestplate.getFirstInventoryIndex(player, Items.FIREWORK_ROCKET);
                        ItemStack firework = player.getInventory().getItem(rocketSlot);
                        if (player.getFallFlyingTicks() % (Integer)CreateQOLConfigs.server().fireworkDuration.get() == 0 || player.getFallFlyingTicks() == 0) {
                            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(level, firework, (LivingEntity)player);
                            level.addFreshEntity((Entity)fireworkrocketentity);
                            player.getInventory().removeItem(rocketSlot, 1);
                        }
                    }
                } else if (level.getGameTime() % 10L == 0L) {
                    Vec3 vec31 = player.getLookAngle();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3 vec32 = player.getDeltaMovement();
                    player.setDeltaMovement(vec32.add(vec31.x * d1 + (vec31.x * d0 - vec32.x) * 0.5, vec31.y * d1 + (vec31.y * d0 - vec32.y) * 0.5, vec31.z * d1 + (vec31.z * d0 - vec32.z) * 0.5));
                    if (!player.isCreative()) {
                        BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (int)1);
                    }
                }
            }
            if (player.isCreative() || player.isSpectator()) {
                return;
            }
            if (ShadowRadianceChestplate.isFansEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty() && ShadowRadianceChestplate.hasPropeller(stack) && ((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue()) {
                boolean hover = ShadowRadianceChestplate.isHoverEnable(stack) && (Boolean)CreateQOLConfigs.server().hoverAllowed.get() != false;
                boolean jumpKeyActive = CommonKeysHandler.isHoldingUp(player);
                boolean shiftKeyActive = CommonKeysHandler.isHoldingDown(player);
                player.resetFallDistance();
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).connection.aboveGroundTickCount = 0;
                }
                if (!player.isSwimming()) {
                    if (jumpKeyActive) {
                        if (!hover) {
                            if (shiftKeyActive) {
                                this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, -0.0));
                            } else {
                                this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, 0.25));
                            }
                        } else if (((Boolean)CreateQOLConfigs.server().hoverAllowed.get()).booleanValue()) {
                            this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, 0.2));
                        }
                        if (second) {
                            BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (int)1);
                        }
                    } else if (hover) {
                        if (((Boolean)CreateQOLConfigs.server().hoverAllowed.get()).booleanValue()) {
                            if (shiftKeyActive) {
                                this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, -0.4));
                            } else {
                                this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, -0.0));
                                if (second) {
                                    BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (int)1);
                                }
                            }
                        }
                    } else if (shiftKeyActive) {
                        this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, -0.4));
                    } else {
                        this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, -0.30000000000000004));
                    }
                    if (CommonKeysHandler.isHoldingForwards(player)) {
                        player.moveRelative(1.0f, new Vec3(0.0, 0.0, player.isSprinting() ? 0.05625 : 0.05));
                    }
                    if (CommonKeysHandler.isHoldingBackwards(player)) {
                        player.moveRelative(1.0f, new Vec3(0.0, 0.0, -0.037500000000000006));
                    }
                    if (CommonKeysHandler.isHoldingLeft(player)) {
                        player.moveRelative(1.0f, new Vec3(0.05, 0.0, 0.0));
                    }
                    if (CommonKeysHandler.isHoldingRight(player)) {
                        player.moveRelative(1.0f, new Vec3(-0.05, 0.0, 0.0));
                    }
                } else if (jumpKeyActive) {
                    player.moveRelative(1.0f, new Vec3(0.0, 0.0, 0.05625));
                    if (second) {
                        BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (int)1);
                    }
                }
            }
        }
    }

    private void pushVertically(Player p, double y) {
        Vec3 motion = p.getDeltaMovement();
        p.setDeltaMovement(motion.get(Direction.Axis.X), y, motion.get(Direction.Axis.Z));
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        components.add((Component)Component.literal((String)"Air : ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)String.valueOf(BacktankUtil.getAir((ItemStack)stack))).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)("/" + BacktankUtil.maxAir((ItemStack)stack))).withStyle(ChatFormatting.GOLD)));
        components.add((Component)Component.literal((String)"Propeller : ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)ShadowRadianceChestplate.chooseState((Boolean)CreateQOLConfigs.server().propellerAllowed.get(), ShadowRadianceChestplate.hasPropeller(stack), true, false, false)).withStyle((Boolean)CreateQOLConfigs.server().propellerAllowed.get() == false ? ChatFormatting.RED : ChatFormatting.YELLOW)));
        if (ShadowRadianceChestplate.hasPropeller(stack) && ((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue()) {
            components.add((Component)Component.empty());
            components.add((Component)Component.literal((String)"Fan : ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)ShadowRadianceChestplate.chooseState(true, true, ShadowRadianceChestplate.isFansEnable(stack), false, true)).withStyle(ChatFormatting.YELLOW)));
            components.add((Component)Component.literal((String)"Hover : ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)ShadowRadianceChestplate.chooseState((Boolean)CreateQOLConfigs.server().hoverAllowed.get(), true, ShadowRadianceChestplate.isHoverEnable(stack), false, true)).withStyle((Boolean)CreateQOLConfigs.server().hoverAllowed.get() == false ? ChatFormatting.RED : ChatFormatting.YELLOW)));
        }
        components.add((Component)Component.literal((String)"Elytra : ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)ShadowRadianceChestplate.chooseState((Boolean)CreateQOLConfigs.server().elytraAllowed.get(), ShadowRadianceChestplate.hasElytra(stack), ShadowRadianceChestplate.isElytraEnable(stack), true, false)).withStyle((Boolean)CreateQOLConfigs.server().elytraAllowed.get() == false ? ChatFormatting.RED : ChatFormatting.YELLOW)));
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    private static String chooseState(boolean config, boolean installed, boolean active, boolean activeReplaceInstall, boolean activeOnly) {
        if (activeOnly) {
            return !config ? "Disabled By Config" : (active ? "Enable" : "Disable");
        }
        return !config ? "Disabled By Config" : (installed ? (activeReplaceInstall ? (active ? "Enable" : "Disable") : "Installed") : "Not Installed");
    }

    public static void toggleFans(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue()) {
            p.displayClientMessage((Component)Component.literal((String)"Propeller is disabled by the config").withStyle(ChatFormatting.RED), true);
            return;
        }
        if (ShadowRadianceChestplate.isElytraEnable(chestplate)) {
            p.displayClientMessage((Component)Component.literal((String)"Fan can't be enabled if the elytra are enabled").withStyle(ChatFormatting.RED), true);
            return;
        }
        chestplate.set(ModDataComponents.BACKTANK_FANS, (Object)(!chestplate.has(ModDataComponents.BACKTANK_FANS) || Boolean.FALSE.equals(chestplate.get(ModDataComponents.BACKTANK_FANS)) ? 1 : 0));
        boolean fans = ShadowRadianceChestplate.isFansEnable(chestplate);
        p.displayClientMessage((Component)Component.literal((String)"Fan : ").append((Component)Component.literal((String)ShadowRadianceChestplate.chooseState(true, true, fans, false, true)).withStyle(fans ? ChatFormatting.GREEN : ChatFormatting.RED)), true);
    }

    public static void toggleHover(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue()) {
            p.displayClientMessage((Component)Component.literal((String)"Propeller is disabled by the config").withStyle(ChatFormatting.RED), true);
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().hoverAllowed.get()).booleanValue()) {
            p.displayClientMessage((Component)Component.literal((String)"Hover is disabled by the config").withStyle(ChatFormatting.RED), true);
            return;
        }
        chestplate.set(ModDataComponents.BACKTANK_HOVER, (Object)(chestplate.has(ModDataComponents.BACKTANK_HOVER) && Boolean.FALSE.equals(chestplate.get(ModDataComponents.BACKTANK_HOVER)) ? 1 : 0));
        boolean hover = ShadowRadianceChestplate.isHoverEnable(chestplate);
        p.displayClientMessage((Component)Component.literal((String)"Hover : ").append((Component)Component.literal((String)ShadowRadianceChestplate.chooseState(true, true, hover, false, true)).withStyle(hover ? ChatFormatting.GREEN : ChatFormatting.RED)), true);
    }

    public static void toggleElytra(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().elytraAllowed.get()).booleanValue()) {
            p.displayClientMessage((Component)Component.literal((String)"Elytra are disabled by the config").withStyle(ChatFormatting.RED), true);
            return;
        }
        if (ShadowRadianceChestplate.isFansEnable(chestplate)) {
            p.displayClientMessage((Component)Component.literal((String)"Elytra can't be enabled if the fans is enabled").withStyle(ChatFormatting.RED), true);
            return;
        }
        chestplate.set(ModDataComponents.BACKTANK_ELYTRA_STATE, (Object)(chestplate.has(ModDataComponents.BACKTANK_ELYTRA_STATE) && Boolean.FALSE.equals(chestplate.get(ModDataComponents.BACKTANK_ELYTRA_STATE)) ? 1 : 0));
        boolean elytra = ShadowRadianceChestplate.isElytraEnable(chestplate);
        p.displayClientMessage((Component)Component.literal((String)"Elytra : ").append((Component)Component.literal((String)ShadowRadianceChestplate.chooseState(true, true, elytra, false, true)).withStyle(elytra ? ChatFormatting.GREEN : ChatFormatting.RED)), true);
    }

    public static boolean hasPropeller(ItemStack chestplate) {
        return chestplate.has(ModDataComponents.BACKTANK_PROPELLERS) && Boolean.TRUE.equals(chestplate.get(ModDataComponents.BACKTANK_PROPELLERS));
    }

    public static boolean hasElytra(ItemStack chestplate) {
        return chestplate.has(ModDataComponents.BACKTANK_ELYTRA) && Boolean.TRUE.equals(chestplate.get(ModDataComponents.BACKTANK_ELYTRA));
    }

    public static boolean isElytraEnable(ItemStack chestplate) {
        return !chestplate.has(ModDataComponents.BACKTANK_ELYTRA_STATE) ? !ShadowRadianceChestplate.isFansEnable(chestplate) : Boolean.TRUE.equals(chestplate.get(ModDataComponents.BACKTANK_ELYTRA_STATE));
    }

    public static boolean isFansEnable(ItemStack chestplate) {
        if (!ShadowRadianceChestplate.hasPropeller(chestplate)) {
            return false;
        }
        return !chestplate.has(ModDataComponents.BACKTANK_FANS) || Boolean.TRUE.equals(chestplate.get(ModDataComponents.BACKTANK_FANS));
    }

    public static boolean isHoverEnable(ItemStack chestplate) {
        if (!ShadowRadianceChestplate.hasPropeller(chestplate)) {
            return false;
        }
        return chestplate.has(ModDataComponents.BACKTANK_HOVER) && Boolean.TRUE.equals(chestplate.get(ModDataComponents.BACKTANK_HOVER));
    }
}

