/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.compat.jei;

import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.menu.GhostItemMenu;
import com.simibubi.create.foundation.gui.menu.GhostItemSubmitPacket;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class QOLGhostIngredientHandler<T extends GhostItemMenu<?>>
implements IGhostIngredientHandler<AbstractSimiContainerScreen<T>> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(AbstractSimiContainerScreen<T> gui, ITypedIngredient<I> ingredient, boolean doStart) {
        LinkedList<IGhostIngredientHandler.Target<I>> targets = new LinkedList<IGhostIngredientHandler.Target<I>>();
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            for (int i = 36; i < ((GhostItemMenu)gui.getMenu()).slots.size(); ++i) {
                if (!((Slot)((GhostItemMenu)gui.getMenu()).slots.get(i)).isActive() || !((Slot)((GhostItemMenu)gui.getMenu()).slots.get(i)).mayPlace(ingredient.getItemStack().orElse(new ItemStack((ItemLike)Items.AIR)))) continue;
                targets.add(new GhostTarget(gui, i - 36));
            }
        }
        return targets;
    }

    public void onComplete() {
    }

    public boolean shouldHighlightTargets() {
        return true;
    }

    private static class GhostTarget<I, T extends GhostItemMenu<?>>
    implements IGhostIngredientHandler.Target<I> {
        private final Rect2i area;
        private final AbstractSimiContainerScreen<T> gui;
        private final int slotIndex;

        public GhostTarget(AbstractSimiContainerScreen<T> gui, int slotIndex) {
            this.gui = gui;
            this.slotIndex = slotIndex;
            Slot slot = (Slot)((GhostItemMenu)gui.getMenu()).slots.get(slotIndex + 36);
            this.area = new Rect2i(gui.getGuiLeft() + slot.x, gui.getGuiTop() + slot.y, 16, 16);
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            ItemStack stack = ((ItemStack)ingredient).copy();
            stack.setCount(1);
            if (!((GhostItemMenu)this.gui.getMenu()).ghostInventory.isItemValid(this.slotIndex, stack)) {
                return;
            }
            ((GhostItemMenu)this.gui.getMenu()).ghostInventory.setStackInSlot(this.slotIndex, stack);
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new GhostItemSubmitPacket(stack, this.slotIndex));
        }
    }
}

