/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import fr.iglee42.createqualityoflife.client.screens.ArmorConfigScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.TickableGuiEventListener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.TextStencilElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ArmorConfigScreenList
extends ObjectSelectionList<Entry>
implements TickableGuiEventListener {
    protected final ArmorConfigScreen parent;

    public ArmorConfigScreenList(Minecraft client, int width, int height, int top, int elementHeight, ArmorConfigScreen parent) {
        super(client, width, height, top, elementHeight);
        this.headerHeight = 3;
        this.parent = parent;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Color c = new Color(0x60000000);
        UIRenderHelper.angledGradient((GuiGraphics)graphics, (float)90.0f, (int)(this.getX() + this.width / 2), (int)this.getY(), (float)this.width, (float)5.0f, (Color)c, (Color)Color.TRANSPARENT_BLACK);
        UIRenderHelper.angledGradient((GuiGraphics)graphics, (float)-90.0f, (int)(this.getX() + this.width / 2), (int)this.getBottom(), (float)this.width, (float)5.0f, (Color)c, (Color)Color.TRANSPARENT_BLACK);
        UIRenderHelper.angledGradient((GuiGraphics)graphics, (float)0.0f, (int)this.getX(), (int)(this.getY() + this.height / 2), (float)this.height, (float)5.0f, (Color)c, (Color)Color.TRANSPARENT_BLACK);
        UIRenderHelper.angledGradient((GuiGraphics)graphics, (float)180.0f, (int)this.getRight(), (int)(this.getY() + this.height / 2), (float)this.height, (float)5.0f, (Color)c, (Color)Color.TRANSPARENT_BLACK);
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.children().isEmpty()) {
            graphics.drawCenteredString(this.minecraft.font, "Please Select an item to configure", this.getX() + this.width / 2, this.getY() + this.getHeight() / 2 - 9, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        }
    }

    protected void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Window window = this.minecraft.getWindow();
        double d0 = window.getGuiScale();
        RenderSystem.enableScissor((int)((int)((double)this.getX() * d0)), (int)((int)((double)window.getHeight() - (double)this.getBottom() * d0)), (int)((int)((double)this.width * d0)), (int)((int)((double)this.height * d0)));
        super.renderListItems(graphics, mouseX, mouseY, partialTick);
        RenderSystem.disableScissor();
    }

    public boolean mouseClicked(double x, double y, int button) {
        return super.mouseClicked(x, y, button);
    }

    public int getRowWidth() {
        return this.width - 16;
    }

    public int getWidth() {
        return this.width;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - 6;
    }

    public void tick() {
        this.children().forEach(Entry::tick);
    }

    public void bumpCog(float force) {
        ArmorConfigScreen.cogSpin.bump(3, (double)force);
    }

    public static class LabeledEntry
    extends Entry {
        protected static final float labelWidthMult = 0.4f;
        public TextStencilElement label;
        protected List<Component> labelTooltip;
        @Nullable
        protected String unit = null;
        protected LerpedFloat differenceAnimation = LerpedFloat.linear().startWithValue(0.0);
        protected LerpedFloat highlightAnimation = LerpedFloat.linear().startWithValue(0.0);

        public LabeledEntry(String label) {
            this.label = new TextStencilElement(Minecraft.getInstance().font, label);
            this.label.withElementRenderer((graphics, width, height, alpha) -> UIRenderHelper.angledGradient((GuiGraphics)graphics, (float)0.0f, (int)0, (int)(height / 2), (float)height, (float)width, (Couple)UIRenderHelper.COLOR_TEXT_STRONG_ACCENT));
            this.labelTooltip = new ArrayList<Component>();
        }

        public LabeledEntry(String label, String path) {
            this(label);
        }

        @Override
        public void tick() {
            this.differenceAnimation.tickChaser();
            this.highlightAnimation.tickChaser();
            super.tick();
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            float animation;
            if (this.differenceAnimation.getChaseTarget() != 0.0f) {
                this.differenceAnimation.chase(0.0, (double)0.6f, LerpedFloat.Chaser.EXP);
            }
            if ((animation = this.differenceAnimation.getValue(partialTicks)) > 0.1f) {
                int offset = (int)(30.0f * (1.0f - animation));
                UIRenderHelper.breadcrumbArrow((GuiGraphics)graphics, (int)(x - 10 - offset), (int)(y + 6), (int)0, (int)-20, (int)24, (int)-18, (Color)new Color(0x70FFFFFF), (Color)Color.TRANSPARENT_BLACK);
            }
            UIRenderHelper.streak((GuiGraphics)graphics, (float)0.0f, (int)(x - 10), (int)(y + height / 2), (int)(height - 6), (int)(width / 8 * 7), (Color)new Color(-587202560));
            UIRenderHelper.streak((GuiGraphics)graphics, (float)180.0f, (int)(x + (int)((float)width * 1.35f) + 10), (int)(y + height / 2), (int)(height - 6), (int)(width / 8 * 7), (Color)new Color(-587202560));
            MutableComponent component = this.label.getComponent();
            Font font = Minecraft.getInstance().font;
            if (font.width((FormattedText)component) > this.getLabelWidth(width) - 10) {
                this.label.withText(font.substrByWidth((FormattedText)component, this.getLabelWidth(width) - 15).getString() + "...");
            }
            if (this.unit != null) {
                int unitWidth = font.width(this.unit);
                graphics.drawString(font, this.unit, x + this.getLabelWidth(width) - unitWidth - 5, y + height / 2 + 2, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB());
                this.label.at((float)(x + 10), (float)(y + height / 2 - 10), 0.0f).render(graphics);
            } else {
                this.label.at((float)(x + 10), (float)(y + height / 2 - 4), 0.0f).render(graphics);
            }
            if (this.annotations.containsKey("highlight")) {
                this.highlightAnimation.startWithValue(1.0).chase(0.0, (double)0.1f, LerpedFloat.Chaser.LINEAR);
                this.annotations.remove("highlight");
            }
            if ((animation = this.highlightAnimation.getValue(partialTicks)) > 0.01f) {
                Color highlight = new Color(-1593835521).scaleAlpha(animation);
                UIRenderHelper.streak((GuiGraphics)graphics, (float)0.0f, (int)(x - 10), (int)(y + height / 2), (int)(height - 6), (int)5, (Color)highlight);
                UIRenderHelper.streak((GuiGraphics)graphics, (float)180.0f, (int)(x + width), (int)(y + height / 2), (int)(height - 6), (int)5, (Color)highlight);
                UIRenderHelper.streak((GuiGraphics)graphics, (float)90.0f, (int)(x + width / 2 - 5), (int)(y + 3), (int)(width + 10), (int)5, (Color)highlight);
                UIRenderHelper.streak((GuiGraphics)graphics, (float)-90.0f, (int)(x + width / 2 - 5), (int)(y + height - 3), (int)(width + 10), (int)5, (Color)highlight);
            }
            if (mouseX > x && mouseX < x + this.getLabelWidth(width) && mouseY > y + 5 && mouseY < y + height - 5) {
                List<Component> tooltip = this.getLabelTooltip();
                if (tooltip.isEmpty()) {
                    return;
                }
                RenderSystem.disableScissor();
                graphics.pose().pushPose();
                graphics.renderComponentTooltip(font, tooltip, mouseX, mouseY);
                graphics.flush();
                graphics.pose().popPose();
                GlStateManager._enableScissorTest();
            }
        }

        public List<Component> getLabelTooltip() {
            return this.labelTooltip;
        }

        protected int getLabelWidth(int totalWidth) {
            return totalWidth;
        }

        public Component getNarration() {
            return CommonComponents.EMPTY;
        }
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements TickableGuiEventListener {
        protected List<GuiEventListener> listeners = new ArrayList<GuiEventListener>();
        protected Map<String, String> annotations = new HashMap<String, String>();

        protected Entry() {
        }

        public boolean mouseClicked(double x, double y, int button) {
            return this.getGuiListeners().stream().anyMatch(l -> l.mouseClicked(x, y, button));
        }

        public boolean keyPressed(int code, int keyPressed_2_, int keyPressed_3_) {
            return this.getGuiListeners().stream().anyMatch(l -> l.keyPressed(code, keyPressed_2_, keyPressed_3_));
        }

        public boolean charTyped(char ch, int code) {
            for (GuiEventListener l : this.getGuiListeners()) {
                if (!l.charTyped(ch, code)) continue;
                return true;
            }
            return false;
        }

        public void tick() {
        }

        public List<GuiEventListener> getGuiListeners() {
            return this.listeners;
        }

        protected void setEditable(boolean b) {
        }
    }
}

