/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.tabs;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import fr.iglee42.createqualityoflife.client.screens.ConfigureStatueScreen;
import fr.iglee42.createqualityoflife.client.screens.tabs.StatueTab;
import fr.iglee42.createqualityoflife.client.screens.widgets.StatuePoseWidget;
import fr.iglee42.createqualityoflife.statue.StatueDefaultRotations;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.world.item.Items;

public class RotationPresetsTab
extends StatueTab {
    private int selected = 6;
    private List<StatuePoseWidget> poses;
    private IconButton previousButton;
    private IconButton nextButton;

    public RotationPresetsTab(int index, ConfigureStatueScreen parent) {
        super(index, Items.ARMOR_STAND, parent, "statue.rotationPresetTab");
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y) {
        this.poses.forEach(p -> {
            p.visible = this.poses.indexOf(p) >= this.selected - 6 && this.poses.indexOf(p) < this.selected;
        });
        this.previousButton.active = this.selected > 6;
        this.nextButton.active = this.selected < this.poses.size();
    }

    @Override
    public void forEachWidgets(Consumer<AbstractWidget> function) {
        this.poses.forEach(function);
        function.accept((AbstractWidget)this.nextButton);
        function.accept((AbstractWidget)this.previousButton);
    }

    @Override
    public void initWidgets(int x, int y) {
        this.poses = new ArrayList<StatuePoseWidget>();
        for (StatueDefaultRotations pose : StatueDefaultRotations.values()) {
            int index = pose.ordinal() % 6;
            int indexInPos = index % 3;
            this.poses.add(new StatuePoseWidget(x + indexInPos * 45, y + (index > 2 ? 80 : 0), pose, this.getParent()));
        }
        this.previousButton = new IconButton(this.getParent().getGuiLeft() + this.getParent().imageWidth - 95, this.getParent().getGuiTop() + this.getParent().imageHeight - 24, (ScreenElement)AllIcons.I_CONFIG_BACK);
        this.previousButton.withCallback(() -> {
            if (this.selected > 6) {
                this.selected -= 6;
            }
        });
        this.nextButton = new IconButton(this.getParent().getGuiLeft() + this.getParent().imageWidth - 75, this.getParent().getGuiTop() + this.getParent().imageHeight - 24, (ScreenElement)AllIcons.I_CONFIG_OPEN);
        this.nextButton.withCallback(() -> {
            int maxIndex = (this.poses.size() - 1) / 6 * 6;
            if (this.selected + 6 <= maxIndex + 6) {
                this.selected += 6;
            }
        });
    }

    @Override
    public void onQuit() {
        super.onQuit();
    }
}

