/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import fr.iglee42.createqualityoflife.blockentitites.ChippedSawBlockEntity;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class ChippedSawRenderer
extends SafeBlockEntityRenderer<ChippedSawBlockEntity> {
    public ChippedSawRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(ChippedSawBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderBlade(be, ms, buffer, light);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)be, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        this.renderShaft(be, ms, buffer, light, overlay);
    }

    protected void renderBlade(ChippedSawBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light) {
        BlockState blockState = be.getBlockState();
        float speed = be.getSpeed();
        boolean rotate = true;
        PartialModel partial = speed > 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE : (speed < 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_REVERSED : AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE);
        SuperByteBuffer superBuffer = CachedBuffers.partialFacing((PartialModel)partial, (BlockState)blockState, (Direction)Direction.UP);
        if (((Direction)blockState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getAxis().equals((Object)Direction.Axis.X)) {
            superBuffer.rotateCentered(AngleHelper.rad((double)90.0), Direction.UP);
        }
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
    }

    protected void renderShaft(ChippedSawBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel(be), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.solid()), (int)light);
    }

    protected void renderItems(ChippedSawBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (be.inventory.isEmpty()) {
            return;
        }
        boolean alongZ = !((Direction)be.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getAxis().equals((Object)Direction.Axis.X);
        float duration = be.inventory.recipeDuration;
        boolean moving = duration != 0.0f;
        float offset = moving ? be.inventory.remainingTime / duration : 0.0f;
        float processingSpeed = Mth.clamp((float)(Math.abs(be.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
        if (moving) {
            offset = Mth.clamp((float)(offset + (-partialTicks + 0.5f) * processingSpeed / duration), (float)0.125f, (float)1.0f);
            if (!be.inventory.appliedRecipe) {
                offset += 1.0f;
            }
            offset /= 2.0f;
        }
        if (be.getSpeed() == 0.0f) {
            offset = 0.5f;
        }
        if (be.getSpeed() < 0.0f ^ alongZ) {
            offset = 1.0f - offset;
        }
        int outputs = 0;
        for (int i = 1; i < be.inventory.getSlots(); ++i) {
            if (be.inventory.getStackInSlot(i).isEmpty()) continue;
            ++outputs;
        }
        ms.pushPose();
        if (alongZ) {
            ms.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        ms.translate(outputs <= 1 ? 0.5 : 0.25, 0.0, (double)offset);
        ms.translate(alongZ ? -1.0f : 0.0f, 0.0f, 0.0f);
        int renderedI = 0;
        for (int i = 0; i < be.inventory.getSlots(); ++i) {
            boolean box;
            ItemStack stack = be.inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            BakedModel modelWithOverrides = itemRenderer.getModel(stack, be.getLevel(), null, 0);
            boolean blockItem = modelWithOverrides.isGui3d();
            ms.pushPose();
            ms.translate(0.0f, blockItem ? 0.925f : 0.8125f, 0.0f);
            if (i > 0 && outputs > 1) {
                ms.translate(0.5 / (double)(outputs - 1) * (double)renderedI, 0.0, 0.0);
                TransformStack.of((PoseStack)ms).nudge(i * 133);
            }
            if (box = PackageItem.isPackage((ItemStack)stack)) {
                ms.translate(0.0f, 0.25f, 0.0f);
                ms.scale(1.5f, 1.5f, 1.5f);
            } else {
                ms.scale(0.5f, 0.5f, 0.5f);
            }
            if (!box) {
                ms.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
            itemRenderer.render(stack, ItemDisplayContext.FIXED, false, ms, buffer, light, overlay, modelWithOverrides);
            ++renderedI;
            ms.popPose();
        }
        ms.popPose();
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be) {
        BlockState state = be.getBlockState();
        return CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)this.getRenderedBlockState(be));
    }

    protected BlockState getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

