/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites;

import com.simibubi.create.content.logistics.tunnel.BrassTunnelModeSlot;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.createqualityoflife.blockentitites.TrashCanBlockEntity;
import fr.iglee42.createqualityoflife.blocks.BrassTrashCanBlock;
import fr.iglee42.createqualityoflife.registries.ModBlockEntities;
import fr.iglee42.createqualityoflife.utils.BrassTrashCanFilterSlotPositioning;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class BrassTrashCanBlockEntity
extends TrashCanBlockEntity {
    FilteringBehaviour filtering;
    protected ScrollOptionBehaviour<Mode> selectionMode;

    public BrassTrashCanBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.BRASS_TRASH_CAN.get(), (be, context) -> be.itemHandler);
    }

    @Override
    public boolean canAcceptItem(ItemStack stack) {
        return super.canAcceptItem(stack) && this.canActivate() && this.filtering.test(stack) && (Boolean)this.getBlockState().getValue((Property)BrassTrashCanBlock.POWERED) == false;
    }

    @Override
    protected int getExtractionAmount() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? this.filtering.getAmount() : 64;
    }

    @Override
    @NotNull
    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() && !this.filtering.upTo ? ItemHelper.ExtractionCountMode.EXACTLY : ItemHelper.ExtractionCountMode.UPTO;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new BrassTrashCanFilterSlotPositioning()).showCountWhen(() -> (Boolean)this.getBlockState().getValue((Property)BrassTrashCanBlock.OPEN));
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.selectionMode = (ScrollOptionBehaviour)new ScrollOptionBehaviour(Mode.class, (Component)CreateLang.translateDirect((String)"options.brass_trash_can.label", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new BrassTunnelModeSlot()).onlyActiveWhen(() -> (Boolean)this.getBlockState().getValue((Property)BrassTrashCanBlock.OPEN) == false);
        behaviours.add((BlockEntityBehaviour)this.selectionMode);
        super.addBehaviours(behaviours);
    }

    public void tick() {
        boolean clientSide;
        super.tick();
        boolean bl = clientSide = this.level != null && this.level.isClientSide && !this.isVirtual();
        if (!clientSide && ((Boolean)this.getBlockState().getValue((Property)BrassTrashCanBlock.OPEN)).booleanValue() && !((Boolean)this.getBlockState().getValue((Property)BrassTrashCanBlock.POWERED)).booleanValue()) {
            this.handleInputFromAbove();
        }
    }

    public static enum Mode implements INamedIconOptions
    {
        VOID(0, AllIcons.I_TRASH),
        KEEP_64(1, AllIcons.I_3x3);

        private int id;
        private AllIcons icon;

        private Mode(int id, AllIcons icon) {
            this.id = id;
            this.icon = icon;
        }

        public int getId() {
            return this.id;
        }

        public static Mode getById(int id) {
            return Arrays.stream(Mode.values()).filter(m -> m.getId() == id).findFirst().orElse(VOID);
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return "options.brass_trash_can." + this.name().toLowerCase();
        }
    }
}

