/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife;

import com.mojang.logging.LogUtils;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.util.RegistrateDistExecutor;
import fr.iglee42.createqualityoflife.CreateQOLClient;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.blockentitites.BrassTrashCanBlockEntity;
import fr.iglee42.createqualityoflife.blockentitites.ChippedSawBlockEntity;
import fr.iglee42.createqualityoflife.blockentitites.InventoryLinkerBlockEntity;
import fr.iglee42.createqualityoflife.blockentitites.TrashCanBlockEntity;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.config.CreateQOLFeaturesConfig;
import fr.iglee42.createqualityoflife.items.ShadowRadianceChestplate;
import fr.iglee42.createqualityoflife.registries.ModBlockEntities;
import fr.iglee42.createqualityoflife.registries.ModBlocks;
import fr.iglee42.createqualityoflife.registries.ModConditions;
import fr.iglee42.createqualityoflife.registries.ModCreativeModeTabs;
import fr.iglee42.createqualityoflife.registries.ModDataComponents;
import fr.iglee42.createqualityoflife.registries.ModEntityDataSerializers;
import fr.iglee42.createqualityoflife.registries.ModEntityTypes;
import fr.iglee42.createqualityoflife.registries.ModItems;
import fr.iglee42.createqualityoflife.registries.ModMenuTypes;
import fr.iglee42.createqualityoflife.registries.ModPackets;
import fr.iglee42.createqualityoflife.registries.ModRecipeTypes;
import fr.iglee42.createqualityoflife.statue.animation.PublishedAnimationsManager;
import fr.iglee42.createqualityoflife.utils.Features;
import fr.iglee42.createqualityoflife.utils.IHaveTankMixin;
import fr.iglee42.createqualityoflife.utils.liquidblazeburners.LiquidBlazeBurnerReloadListener;
import java.io.IOException;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.slf4j.Logger;

@Mod(value="createqol")
public class CreateQOL {
    public static final String MODID = "createqol";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"createqol").defaultCreativeTab((ResourceKey)null);

    public CreateQOL(IEventBus modEventBus, ModContainer container) throws IOException, IllegalAccessException {
        IEventBus forgeEventBus = NeoForge.EVENT_BUS;
        CreateQOLFeaturesConfig.load();
        REGISTRATE.registerEventListeners(modEventBus);
        ModBlocks.register();
        ModBlockEntities.register();
        ModItems.register();
        ModCreativeModeTabs.register(modEventBus);
        ModPackets.register();
        ModDataComponents.register(modEventBus);
        ModConditions.CONDITIONS.register(modEventBus);
        ModRecipeTypes.register(modEventBus);
        ModEntityDataSerializers.ENTITY_SERIALIZERS.register(modEventBus);
        ModEntityTypes.ENTITIES.register(modEventBus);
        ModMenuTypes.register();
        CreateQOLConfigs.register(ModLoadingContext.get(), container);
        RegistrateDistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateQOLClient.onCtorClient(modEventBus, forgeEventBus));
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(ChippedSawBlockEntity::registerCapabilities);
        modEventBus.addListener(InventoryLinkerBlockEntity::registerCapabilities);
        modEventBus.addListener(TrashCanBlockEntity::registerCapabilities);
        modEventBus.addListener(BrassTrashCanBlockEntity::registerCapabilities);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(ModEntityTypes::registerEntityAttributes);
        forgeEventBus.addListener(this::removeFallDamage);
        forgeEventBus.addListener(this::registerReloadListener);
        forgeEventBus.addListener(this::playerJoin);
        forgeEventBus.addListener(this::onWorldTick);
        forgeEventBus.addListener(this::itemTooltips);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)AllBlockEntityTypes.HEATER.get(), (be, context) -> {
            if (!CreateQOL.isActivate(Features.LIQUID_BLAZE_BURNER)) {
                return null;
            }
            if (!(be instanceof IHaveTankMixin)) {
                return null;
            }
            IHaveTankMixin tank = (IHaveTankMixin)be;
            return tank.createQOL$tank();
        });
    }

    private void registerReloadListener(AddReloadListenerEvent event) {
        if (!CreateQOL.isActivate(Features.LIQUID_BLAZE_BURNER)) {
            return;
        }
        event.addListener((PreparableReloadListener)LiquidBlazeBurnerReloadListener.INSTANCE);
    }

    public static boolean isChippedLoaded() {
        return ModList.get().isLoaded("chipped");
    }

    public static boolean isActivate(Features feature) {
        return feature.getConfig();
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    public void removeFallDamage(LivingIncomingDamageEvent event) {
        if (!event.getSource().equals(event.getEntity().level().damageSources().fall())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.getItemBySlot(EquipmentSlot.CHEST).is(ModItems.SHADOW_RADIANCE_CHESTPLATE)) {
            ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
            if (BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty()) {
                return;
            }
            if (ShadowRadianceChestplate.isFansEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty() && ShadowRadianceChestplate.hasPropeller(stack)) {
                event.setCanceled(true);
            }
        }
    }

    private void playerJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (event.getLevel().isClientSide) {
            return;
        }
        ServerPlayer player = (ServerPlayer)p;
        if (event.getLevel().getServer() == null) {
            return;
        }
        if (event.getLevel().getServer().getProfilePermissions(p.getGameProfile()) < 1) {
            return;
        }
        if (CreateQOL.isActivate(Features.STATUE) && ((Boolean)CreateQOLConfigs.server().experimentalWarning.get()).booleanValue()) {
            player.displayClientMessage((Component)Component.literal((String)"Warning: Statue are still a beta feature, some bugs and crash might appear.\nPlease report them on https://issues-qol.iglee.fr").withStyle(ChatFormatting.YELLOW), false);
        }
    }

    public void onWorldTick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        PublishedAnimationsManager manager = PublishedAnimationsManager.get(event.getLevel());
        manager.tick();
    }

    public void itemTooltips(ItemTooltipEvent event) {
        if (!event.getItemStack().is(Items.FIREWORK_ROCKET)) {
            return;
        }
        if (CreateQOL.isActivate(Features.SHADOW_RADIANCE) && ((Boolean)CreateQOLConfigs.server().elytraBoostAllowed.get()).booleanValue() && ((Boolean)CreateQOLConfigs.server().useFireworksForBoost.get()).booleanValue()) {
            event.getToolTip().add(2, CreateQOLLang.translateDirect("chestplate.use_fireworks", new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

