/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.comparator.DoubleComparator;
import corgitaco.corgilib.serialization.codec.CodecUtil;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class ItemStackCheck {
    public static final Codec<ItemStackCheck> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtil.ITEM_CODEC.fieldOf("item").forGetter(itemStackCheck -> itemStackCheck.item), (App)DoubleComparator.CODEC.optionalFieldOf("durability_is").forGetter(itemStackCheck -> itemStackCheck.durabilityComparator), (App)DoubleComparator.CODEC.optionalFieldOf("stack_size_is").forGetter(itemStackCheck -> itemStackCheck.stackSizeComparator), (App)Codec.unboundedMap((Codec)Enchantment.CODEC, DoubleComparator.CODEC).optionalFieldOf("enchantment_check").forGetter(itemStackCheck -> itemStackCheck.enchantmentLevelComparator)).apply((Applicative)builder, ItemStackCheck::new));
    private final Item item;
    private final Optional<DoubleComparator> durabilityComparator;
    private final Optional<DoubleComparator> stackSizeComparator;
    private final Optional<Map<Holder<Enchantment>, DoubleComparator>> enchantmentLevelComparator;

    public ItemStackCheck(Item item, Optional<DoubleComparator> durabilityComparator, Optional<DoubleComparator> stackSizeComparator, Optional<Map<Holder<Enchantment>, DoubleComparator>> enchantmentLevelComparator) {
        this.item = item;
        if (durabilityComparator.isEmpty() && stackSizeComparator.isEmpty() && enchantmentLevelComparator.isEmpty()) {
            throw new IllegalArgumentException("We need at least one check in an Item Stack Check!");
        }
        this.durabilityComparator = durabilityComparator;
        this.stackSizeComparator = stackSizeComparator;
        this.enchantmentLevelComparator = enchantmentLevelComparator;
    }

    public boolean test(ItemStack itemStack) {
        if (this.item == itemStack.getItem()) {
            if (this.durabilityComparator.isPresent() && !this.durabilityComparator.get().check(itemStack.getDamageValue())) {
                return false;
            }
            if (this.stackSizeComparator.isPresent() && !this.stackSizeComparator.get().check(itemStack.getCount())) {
                return false;
            }
            if (this.enchantmentLevelComparator.isPresent()) {
                Map<Holder<Enchantment>, DoubleComparator> enchantmentComparator = this.enchantmentLevelComparator.get();
                ItemEnchantments enchantments = itemStack.getEnchantments();
                Set holders = enchantments.keySet();
                for (Holder enchantmentHolder : holders) {
                    DoubleComparator doubleComparator;
                    if (!enchantmentComparator.containsKey(enchantmentHolder) || (doubleComparator = enchantmentComparator.get(enchantmentHolder)).check(enchantments.getLevel(enchantmentHolder))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Item getItem() {
        return this.item;
    }
}

