/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.neoforgespi.Environment;

public class RegistryHelper {
    @Nullable
    public static <T> Registry<T> getRegistry(ResourceKey<Registry<T>> registry) {
        return CSMath.getIfNotNull(RegistryHelper.getRegistryAccess(), access -> access.registryOrThrow(registry), null);
    }

    @Nullable
    public static RegistryAccess getRegistryAccess() {
        Object access = null;
        MinecraftServer server = WorldHelper.getServer();
        if (server != null) {
            ServerLevel level = server.getLevel(Level.OVERWORLD);
            access = level != null ? level.registryAccess() : server.registryAccess();
        }
        if (access == null && Environment.get().getDist() == Dist.CLIENT) {
            if (Minecraft.getInstance().level != null) {
                access = Minecraft.getInstance().level.registryAccess();
            } else {
                ClientPacketListener connection = Minecraft.getInstance().getConnection();
                if (connection != null) {
                    access = connection.registryAccess();
                }
            }
        }
        return access;
    }

    public static <T> List<T> mapBuiltinRegistryTagList(Registry<T> registry, List<Either<TagKey<T>, T>> eitherList) {
        ArrayList list = new ArrayList();
        if (registry == null) {
            return list;
        }
        for (Either<TagKey<T>, T> either : eitherList) {
            either.ifLeft(tagKey -> {
                Optional tag = registry.getTag(tagKey);
                tag.ifPresent(tag1 -> list.addAll(tag1.stream().map(Holder::value).toList()));
            });
            either.ifRight(list::add);
        }
        return list;
    }

    public static <T> List<Holder<T>> mapRegistryTagList(ResourceKey<Registry<T>> registry, List<Either<TagKey<T>, Holder<T>>> eitherList, @Nullable RegistryAccess registryAccess) {
        Registry reg = registryAccess != null ? registryAccess.registryOrThrow(registry) : RegistryHelper.getRegistry(registry);
        ArrayList list = new ArrayList();
        if (reg == null) {
            return list;
        }
        for (Either<TagKey<T>, Holder<T>> either : eitherList) {
            either.ifLeft(tagKey -> {
                Optional tag = reg.getTag(tagKey);
                tag.ifPresent(tag1 -> list.addAll(tag1.stream().toList()));
            });
            either.ifRight(list::add);
        }
        return list;
    }

    public static <T> Optional<T> getVanillaRegistryValue(ResourceKey<Registry<T>> registry, ResourceLocation id) {
        try {
            return Optional.ofNullable(RegistryHelper.getRegistry(registry)).map(reg -> reg.get(id));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Nullable
    public static ResourceLocation getKey(Holder<?> holder) {
        return holder.unwrapKey().map(ResourceKey::location).orElse(null);
    }

    @Nullable
    public static Holder<Biome> getBiome(ResourceLocation biomeId, RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(Registries.BIOME).getHolder(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeId)).orElse(null);
    }

    @Nullable
    public static ResourceLocation getBiomeId(Biome biome, RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(Registries.BIOME).getKey((Object)biome);
    }

    @Nullable
    public static Holder<DimensionType> getDimension(ResourceLocation dimensionId, RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(Registries.DIMENSION_TYPE).getHolder(ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)dimensionId)).orElse(null);
    }

    @Nullable
    public static ResourceLocation getDimensionId(DimensionType dimension, RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(Registries.DIMENSION_TYPE).getKey((Object)dimension);
    }

    @Nullable
    public static Holder<Structure> getStructure(ResourceLocation structureId, RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(Registries.STRUCTURE).getHolder(ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)structureId)).orElse(null);
    }

    @Nullable
    public static ResourceLocation getStructureId(Structure structure, RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(Registries.STRUCTURE).getKey((Object)structure);
    }
}

