/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.util.exceptions.SerializationException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.fml.util.thread.EffectiveSide;

public class DynamicHolder<T>
implements Supplier<T> {
    private T value;
    private Supplier<T> valueCreator;
    private Loader<T> loader;
    private Saver<T> saver;
    private Writer<T> encoder;
    private Reader<T> decoder;
    private SyncType syncType = SyncType.NONE;
    private boolean requireRegistries = false;

    protected DynamicHolder(Supplier<T> valueCreator, Consumer<DynamicHolder<T>> loader) {
        this.valueCreator = valueCreator;
        this.loader = (holder, registryAccess) -> loader.accept(holder);
    }

    protected DynamicHolder(Supplier<T> valueCreator, Loader<T> loader) {
        this.valueCreator = valueCreator;
        this.loader = loader;
    }

    public static <T> DynamicHolder<T> createWithRegistries(Supplier<T> valueCreator, Loader<T> loader) {
        DynamicHolder<T> holder = new DynamicHolder<T>(valueCreator, loader);
        holder.requireRegistries = true;
        return holder;
    }

    public static <T> DynamicHolder<T> create(Supplier<T> valueCreator, Consumer<DynamicHolder<T>> loader) {
        return new DynamicHolder<T>(valueCreator, loader);
    }

    public static <T> DynamicHolder<T> create(Supplier<T> valueCreator) {
        return new DynamicHolder<T>(valueCreator, holder -> {});
    }

    public static <T> DynamicHolder<T> createSyncedWithRegistries(Supplier<T> valueCreator, Loader<T> loader, Writer<T> encoder, Reader<T> decoder, Saver<T> saver, SyncType syncType) {
        if (syncType == SyncType.NONE) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("SyncType cannot be NONE for a synced DynamicHolder."));
        }
        DynamicHolder<T> holder = new DynamicHolder<T>(valueCreator, loader);
        holder.encoder = encoder;
        holder.decoder = decoder;
        holder.saver = saver;
        holder.syncType = syncType;
        holder.requireRegistries = true;
        return holder;
    }

    public static <T> DynamicHolder<T> createSynced(Supplier<T> valueCreator, Consumer<DynamicHolder<T>> loader, Function<T, CompoundTag> encoder, Function<CompoundTag, T> decoder, Consumer<T> saver, SyncType syncType) {
        if (syncType == SyncType.NONE) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("SyncType cannot be NONE for a synced DynamicHolder."));
        }
        DynamicHolder<T> holder = new DynamicHolder<T>(valueCreator, loader);
        holder.encoder = (val, registryAccess) -> (CompoundTag)encoder.apply(val);
        holder.decoder = (tag, registryAccess) -> decoder.apply(tag);
        holder.saver = (val, registryAccess) -> saver.accept(val);
        holder.syncType = syncType;
        return holder;
    }

    @Override
    public T get() {
        if (this.requireRegistries) {
            throw (RuntimeException)ColdSweat.LOGGER.throwing((Throwable)new RuntimeException("RegistryAccess is required for this DynamicHolder, yet none was provided."));
        }
        if (this.value == null) {
            this.load(true);
        }
        return this.value;
    }

    public T get(RegistryAccess registryAccess) {
        if (this.value == null) {
            this.load(registryAccess, true);
        }
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public void setUnsafe(Object value) {
        this.value = value;
    }

    public void load(boolean replace) {
        if (replace) {
            this.value = this.valueCreator.get();
        }
        this.loader.load(this, null);
    }

    public void load(RegistryAccess registryAccess, boolean replace) {
        if (replace) {
            this.value = this.valueCreator.get();
        }
        this.loader.load(this, registryAccess);
    }

    public CompoundTag encode(RegistryAccess registryAccess) {
        if (!this.isSynced()) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)SerializationException.serialize(this.value, "Tried to encode non-synced DynamicHolder", null));
        }
        try {
            return this.encoder.write(this.get(registryAccess), registryAccess);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)SerializationException.serialize(this.value, "Failed to encode DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public void decode(CompoundTag tag, RegistryAccess registryAccess) {
        if (!this.isSynced()) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Tried to decode non-synced DynamicHolder"));
        }
        try {
            this.value = this.decoder.read(tag, registryAccess);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Failed to decode DynamicHolder", e));
        }
    }

    public void save(RegistryAccess registryAccess) {
        if (!this.isSynced()) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Tried to save non-synced DynamicHolder"));
        }
        try {
            this.saver.save(this.get(registryAccess), registryAccess);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Failed to save DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public void reset() {
        this.value = this.valueCreator.get();
    }

    public boolean isSynced() {
        return this.syncType != SyncType.NONE;
    }

    public SyncType getSyncType() {
        return this.syncType;
    }

    public boolean requiresRegistries() {
        return this.requireRegistries;
    }

    public static enum SyncType {
        NONE,
        BOTH_WAYS,
        ONE_WAY;


        public boolean canSend() {
            return this == BOTH_WAYS || this == ONE_WAY && EffectiveSide.get().isServer();
        }

        public boolean canReceive() {
            return this == BOTH_WAYS || this == ONE_WAY && EffectiveSide.get().isClient() && !Minecraft.getInstance().isLocalServer();
        }
    }

    @FunctionalInterface
    public static interface Loader<T> {
        public void load(DynamicHolder<T> var1, RegistryAccess var2);
    }

    @FunctionalInterface
    public static interface Writer<T> {
        public CompoundTag write(T var1, RegistryAccess var2);
    }

    @FunctionalInterface
    public static interface Reader<T> {
        public T read(CompoundTag var1, RegistryAccess var2);
    }

    @FunctionalInterface
    public static interface Saver<T> {
        public void save(T var1, RegistryAccess var2);
    }
}

