/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigLoadingHandler;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import com.momosoftworks.coldsweat.util.math.RegistryMultiMap;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.util.TriConsumer;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static <T> List<Either<TagKey<T>, Holder<T>>> parseRegistryItems(ResourceKey<Registry<T>> registry, RegistryAccess registryAccess, String objects) {
        return ConfigHelper.parseRegistryItems(registry, registryAccess, objects.split(","));
    }

    public static <T> List<Either<TagKey<T>, Holder<T>>> parseRegistryItems(ResourceKey<Registry<T>> registry, RegistryAccess registryAccess, String[] objects) {
        ArrayList<Either<TagKey<T>, Holder<T>>> registryList = new ArrayList<Either<TagKey<T>, Holder<T>>>();
        Registry reg = registryAccess.registryOrThrow(registry);
        for (String objString : objects) {
            if (objString.startsWith("#")) {
                String tagID = objString.replace("#", "");
                registryList.add(Either.left((Object)TagKey.create(registry, (ResourceLocation)ResourceLocation.parse((String)tagID))));
                continue;
            }
            ResourceLocation id = ResourceLocation.parse((String)objString);
            Optional obj = reg.getHolder(ResourceKey.create(registry, (ResourceLocation)id));
            if (!reg.containsKey(id) || obj.isEmpty()) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" does not exist", (Object)registry.location().getPath(), (Object)objString);
                continue;
            }
            registryList.add(Either.right((Object)((Holder)obj.get())));
        }
        return registryList;
    }

    public static <T> List<Either<TagKey<T>, T>> parseBuiltinItems(ResourceKey<Registry<T>> registryKey, Registry<T> registry, String objects) {
        return ConfigHelper.parseBuiltinItems(registryKey, registry, objects.split(","));
    }

    public static <T> List<Either<TagKey<T>, T>> parseBuiltinItems(ResourceKey<Registry<T>> registryKey, Registry<T> registry, String[] objects) {
        ArrayList<Either<TagKey<T>, T>> registryList = new ArrayList<Either<TagKey<T>, T>>();
        for (String objString : objects) {
            if (objString.startsWith("#")) {
                String tagID = objString.replace("#", "");
                registryList.add(Either.left((Object)TagKey.create(registryKey, (ResourceLocation)ResourceLocation.parse((String)tagID))));
                continue;
            }
            ResourceLocation id = ResourceLocation.parse((String)objString);
            if (!registry.containsKey(id)) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" does not exist", (Object)registryKey.location().getPath(), (Object)objString);
                continue;
            }
            Object obj = registry.get(id);
            registryList.add(Either.right((Object)obj));
        }
        return registryList;
    }

    public static List<Either<TagKey<Block>, Block>> getBlocks(String blocks) {
        return ConfigHelper.getBlocks(blocks.split(","));
    }

    public static List<Either<TagKey<Block>, Block>> getBlocks(String[] blocks) {
        return ConfigHelper.parseBuiltinItems(Registries.BLOCK, BuiltInRegistries.BLOCK, blocks);
    }

    public static List<Either<TagKey<Item>, Item>> getItems(String items) {
        return ConfigHelper.getItems(items.split(","));
    }

    public static List<Either<TagKey<Item>, Item>> getItems(String[] items) {
        return ConfigHelper.parseBuiltinItems(Registries.ITEM, BuiltInRegistries.ITEM, items);
    }

    public static List<Either<TagKey<EntityType<?>>, EntityType<?>>> getEntityTypes(String entities) {
        return ConfigHelper.getEntityTypes(entities.split(","));
    }

    public static List<Either<TagKey<EntityType<?>>, EntityType<?>>> getEntityTypes(String[] entities) {
        return ConfigHelper.parseBuiltinItems(Registries.ENTITY_TYPE, BuiltInRegistries.ENTITY_TYPE, entities);
    }

    public static <K, V extends ConfigData> Multimap<K, V> parseTomlRegistry(ModConfigSpec.ConfigValue<List<? extends List<?>>> config, Function<List<?>, V> tomlParser, Function<V, List<Either<TagKey<K>, K>>> keyListGetter, Registry<K> keyRegistry, ResourceKey<Registry<V>> valueRegistry) {
        RegistryMultiMap dataMap = new RegistryMultiMap();
        for (List entry : (List)config.get()) {
            ConfigData data = (ConfigData)tomlParser.apply(entry);
            if (data == null) continue;
            data.setRegistryType(ConfigData.Type.TOML);
            RegistryHelper.mapBuiltinRegistryTagList(keyRegistry, keyListGetter.apply(data)).forEach(ent -> dataMap.put(ent, data));
        }
        ConfigLoadingHandler.removeEntries(dataMap.values(), valueRegistry);
        return dataMap;
    }

    public static <K, V extends ConfigData> Map<K, V> parseTomlRegistryUnique(ModConfigSpec.ConfigValue<List<? extends List<?>>> config, Function<List<?>, V> tomlParser, Function<V, List<Either<TagKey<K>, K>>> keyListGetter, Registry<K> keyRegistry, ResourceKey<Registry<V>> valueRegistry) {
        HashMap dataMap = new HashMap();
        for (List entry : (List)config.get()) {
            ConfigData data = (ConfigData)tomlParser.apply(entry);
            if (data == null) continue;
            data.setRegistryType(ConfigData.Type.TOML);
            RegistryHelper.mapBuiltinRegistryTagList(keyRegistry, keyListGetter.apply(data)).forEach(ent -> dataMap.put(ent, data));
        }
        ConfigLoadingHandler.removeEntries(dataMap.values(), valueRegistry);
        return dataMap;
    }

    private static <K, V> void putRegistryEntries(Multimap<K, V> map, Registry<K> registry, List<Either<TagKey<K>, K>> list, V data) {
        RegistryHelper.mapBuiltinRegistryTagList(registry, list).forEach(entry -> map.put(entry, data));
    }

    public static <K, V extends ConfigData> Map<Holder<K>, V> getRegistryMap(List<? extends List<?>> source, RegistryAccess registryAccess, ResourceKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, List<Either<TagKey<K>, Holder<K>>>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, registryAccess, keyRegistry, valueCreator, taggedListGetter, FastMap::new, FastMap::put);
    }

    public static <K, V extends ConfigData> Multimap<Holder<K>, V> getRegistryMultimap(List<? extends List<?>> source, RegistryAccess registryAccess, ResourceKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, List<Either<TagKey<K>, Holder<K>>>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, registryAccess, keyRegistry, valueCreator, taggedListGetter, FastMultiMap::new, FastMultiMap::put);
    }

    private static <K, V extends ConfigData, M> M getRegistryMapLike(List<? extends List<?>> source, RegistryAccess registryAccess, ResourceKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, List<Either<TagKey<K>, Holder<K>>>> taggedListGetter, Supplier<M> mapSupplier, TriConsumer<M, Holder<K>, V> mapAdder) {
        M map = mapSupplier.get();
        for (List<?> entry : source) {
            ConfigData data = (ConfigData)valueCreator.apply(entry);
            if (data != null) {
                data.setRegistryType(ConfigData.Type.TOML);
                for (Holder<K> key : RegistryHelper.mapRegistryTagList(keyRegistry, taggedListGetter.apply(data), registryAccess)) {
                    mapAdder.accept(map, key, (Object)data);
                }
                continue;
            }
            ColdSweat.LOGGER.error("Error parsing {} config \"{}\"", (Object)keyRegistry.location(), (Object)entry.toString());
        }
        return map;
    }

    public static CompoundTag serializeNbtBool(boolean value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(key, value);
        return tag;
    }

    public static CompoundTag serializeNbtInt(int value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.putInt(key, value);
        return tag;
    }

    public static CompoundTag serializeNbtDouble(double value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.putDouble(key, value);
        return tag;
    }

    public static <A, B> CompoundTag serializeNbtPair(Pair<A, B> value, Function<A, Tag> left, Function<B, Tag> right, String key) {
        CompoundTag tag = new CompoundTag();
        tag.put(key + "_left", left.apply(value.getFirst()));
        tag.put(key + "_right", right.apply(value.getSecond()));
        return tag;
    }

    public static <A, B, T extends Tag> Pair<A, B> deserializeNbtPair(CompoundTag tag, Function<T, A> left, Function<T, B> right, String key) {
        try {
            Tag leftTag = tag.get(key + "_left");
            Tag rightTag = tag.get(key + "_right");
            return Pair.of(left.apply(leftTag), right.apply(rightTag));
        }
        catch (ClassCastException e) {
            throw (ClassCastException)ColdSweat.LOGGER.throwing((Throwable)new ClassCastException(String.format("Error deserializing config setting {}: Wrong object type.", tag)));
        }
    }

    public static CompoundTag serializeNbtString(String value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.putString(key, value);
        return tag;
    }

    public static <K, V extends ConfigData> CompoundTag serializeRegistry(Map<K, V> map, String key, ResourceKey<Registry<K>> gameRegistry, ResourceKey<Registry<V>> modRegistry, Function<K, ResourceLocation> keyGetter) {
        return ConfigHelper.serializeEitherRegistry(map, key, gameRegistry, modRegistry, null, keyGetter);
    }

    public static <K, V extends ConfigData> CompoundTag serializeHolderRegistry(Map<Holder<K>, V> map, String key, ResourceKey<Registry<K>> gameRegistry, ResourceKey<Registry<V>> modRegistry, RegistryAccess registryAccess) {
        return ConfigHelper.serializeEitherRegistry(map, key, gameRegistry, modRegistry, registryAccess, RegistryHelper::getKey);
    }

    private static <K, V extends ConfigData> CompoundTag serializeEitherRegistry(Map<K, V> map, String key, ResourceKey<?> gameRegistry, ResourceKey<Registry<V>> modRegistry, RegistryAccess registryAccess, Function<K, ResourceLocation> keyGetter) {
        Codec<V> codec = ModRegistries.getCodec(modRegistry);
        NbtOps encoderOps = registryAccess != null ? RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryAccess) : NbtOps.INSTANCE;
        CompoundTag tag = new CompoundTag();
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry entry : map.entrySet()) {
            ResourceLocation elementId = keyGetter.apply(entry.getKey());
            if (elementId == null) {
                ColdSweat.LOGGER.error("Error serializing {}: \"{}\" does not exist", (Object)gameRegistry.location(), entry.getKey());
                continue;
            }
            codec.encode((Object)((ConfigData)entry.getValue()), (DynamicOps)encoderOps, (Object)((Tag)encoderOps.empty())).resultOrPartial(e -> ColdSweat.LOGGER.error("Error serializing {} {}: {}", (Object)modRegistry.location(), entry.getValue(), e)).ifPresent(encoded -> {
                ((CompoundTag)encoded).putUUID("UUID", ((ConfigData)entry.getValue()).uuid());
                mapTag.put(elementId.toString(), encoded);
            });
        }
        tag.put(key, (Tag)mapTag);
        return tag;
    }

    public static <K, V extends ConfigData> Map<K, V> deserializeRegistry(CompoundTag tag, String key, ResourceKey<Registry<V>> modRegistry, Function<ResourceLocation, K> keyGetter) {
        return ConfigHelper.deserializeEitherRegistry(tag, key, modRegistry, keyGetter, null);
    }

    public static <K, V extends ConfigData> Map<Holder<K>, V> deserializeHolderRegistry(CompoundTag tag, String key, ResourceKey<Registry<K>> gameRegistry, ResourceKey<Registry<V>> modRegistry, RegistryAccess registryAccess) {
        Registry registry = registryAccess.registryOrThrow(gameRegistry);
        return ConfigHelper.deserializeEitherRegistry(tag, key, modRegistry, k -> registry.getHolder(ResourceKey.create((ResourceKey)gameRegistry, (ResourceLocation)k)).orElse(null), registryAccess);
    }

    private static <K, V extends ConfigData> Map<K, V> deserializeEitherRegistry(CompoundTag tag, String key, ResourceKey<Registry<V>> modRegistry, Function<ResourceLocation, K> keyGetter, RegistryAccess registryAccess) {
        Codec<V> codec = ModRegistries.getCodec(modRegistry);
        FastMap map = new FastMap();
        CompoundTag mapTag = tag.getCompound(key);
        NbtOps decoderOps = registryAccess != null ? RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryAccess) : NbtOps.INSTANCE;
        for (String entryKey : mapTag.getAllKeys()) {
            CompoundTag entryData = mapTag.getCompound(entryKey);
            codec.decode((DynamicOps)decoderOps, (Object)entryData).resultOrPartial(e -> ColdSweat.LOGGER.error("Error deserializing {}: {}", (Object)modRegistry.location(), e)).map(Pair::getFirst).ifPresent(value -> {
                Object entry = keyGetter.apply(ResourceLocation.parse((String)entryKey));
                if (entry != null) {
                    value.setId(entryData.getUUID("UUID"));
                    map.put(entry, value);
                }
            });
        }
        return map;
    }

    public static <K, V extends ConfigData> CompoundTag serializeMultimapRegistry(Multimap<K, V> map, String key, ResourceKey<Registry<K>> gameRegistry, ResourceKey<Registry<V>> modRegistry, Function<K, ResourceLocation> keyGetter) {
        return ConfigHelper.serializeEitherMultimapRegistry(map, key, gameRegistry, modRegistry, null, keyGetter);
    }

    public static <K, V extends ConfigData> CompoundTag serializeHolderMultimapRegistry(Multimap<Holder<K>, V> map, String key, ResourceKey<Registry<K>> gameRegistry, ResourceKey<Registry<V>> modRegistry, RegistryAccess registryAccess) {
        return ConfigHelper.serializeEitherMultimapRegistry(map, key, gameRegistry, modRegistry, registryAccess, RegistryHelper::getKey);
    }

    private static <K, V extends ConfigData> CompoundTag serializeEitherMultimapRegistry(Multimap<K, V> map, String key, ResourceKey<?> gameRegistry, ResourceKey<Registry<V>> modRegistry, RegistryAccess registryAccess, Function<K, ResourceLocation> keyGetter) {
        Codec<V> codec = ModRegistries.getCodec(modRegistry);
        NbtOps encoderOps = registryAccess != null ? RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryAccess) : NbtOps.INSTANCE;
        CompoundTag tag = new CompoundTag();
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry entry : map.asMap().entrySet()) {
            ResourceLocation elementId = keyGetter.apply(entry.getKey());
            if (elementId == null) {
                ColdSweat.LOGGER.error("Error serializing {}: \"{}\" does not exist", (Object)gameRegistry.location(), entry.getKey());
                continue;
            }
            ListTag valuesTag = new ListTag();
            for (ConfigData value : (Collection)entry.getValue()) {
                codec.encode((Object)value, (DynamicOps)encoderOps, (Object)((Tag)encoderOps.empty())).resultOrPartial(e -> ColdSweat.LOGGER.error("Error serializing {} {}: {}", (Object)modRegistry.location(), entry.getValue(), e)).ifPresent(encoded -> {
                    ((CompoundTag)encoded).putUUID("UUID", value.uuid());
                    valuesTag.add(encoded);
                });
            }
            mapTag.put(elementId.toString(), (Tag)valuesTag);
        }
        tag.put(key, (Tag)mapTag);
        return tag;
    }

    public static <K, V extends ConfigData> Multimap<K, V> deserializeMultimapRegistry(CompoundTag tag, String key, ResourceKey<Registry<V>> modRegistry, Function<ResourceLocation, K> keyGetter) {
        return ConfigHelper.deserializeEitherMultimapRegistry(tag, key, modRegistry, keyGetter, null);
    }

    public static <K, V extends ConfigData> Multimap<Holder<K>, V> deserializeHolderMultimapRegistry(CompoundTag tag, String key, ResourceKey<Registry<K>> gameRegistry, ResourceKey<Registry<V>> modRegistry, RegistryAccess registryAccess) {
        Registry registry = registryAccess.registryOrThrow(gameRegistry);
        return ConfigHelper.deserializeEitherMultimapRegistry(tag, key, modRegistry, k -> registry.getHolder(ResourceKey.create((ResourceKey)gameRegistry, (ResourceLocation)k)).orElse(null), registryAccess);
    }

    private static <K, V extends ConfigData> Multimap<K, V> deserializeEitherMultimapRegistry(CompoundTag tag, String key, ResourceKey<Registry<V>> modRegistry, Function<ResourceLocation, K> keyGetter, RegistryAccess registryAccess) {
        Codec<V> codec = ModRegistries.getCodec(modRegistry);
        NbtOps decoderOps = registryAccess != null ? RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryAccess) : NbtOps.INSTANCE;
        FastMultiMap map = new FastMultiMap();
        CompoundTag mapTag = tag.getCompound(key);
        for (String entryKey : mapTag.getAllKeys()) {
            ListTag entryData = mapTag.getList(entryKey, 10);
            Object object = keyGetter.apply(ResourceLocation.parse((String)entryKey));
            if (object == null) {
                ColdSweat.LOGGER.error("Error deserializing: \"{}\" does not exist in registry", (Object)entryKey);
                continue;
            }
            for (Tag valueTag : entryData) {
                CompoundTag valueData = (CompoundTag)valueTag;
                codec.decode((DynamicOps)decoderOps, (Object)valueData).result().map(Pair::getFirst).ifPresent(value -> {
                    value.setId(valueData.getUUID("UUID"));
                    map.put(object, value);
                });
            }
        }
        return map;
    }

    public static <T> void writeRegistryMap(Map<Item, T> map, Function<T, List<String>> keyWriter, Function<T, List<?>> valueWriter, Consumer<List<? extends List<?>>> saver) {
        ConfigHelper.writeRegistryMapLike(Either.left(map), keyWriter, valueWriter, saver);
    }

    public static <K, V> void writeRegistryMultimap(Multimap<K, V> map, Function<V, List<String>> keyWriter, Function<V, List<?>> valueWriter, Consumer<List<? extends List<?>>> saver) {
        ConfigHelper.writeRegistryMapLike(Either.right(map), keyWriter, valueWriter, saver);
    }

    private static <K, V> void writeRegistryMapLike(Either<Map<K, V>, Multimap<K, V>> map, Function<V, List<String>> keyWriter, Function<V, List<?>> valueWriter, Consumer<List<? extends List<?>>> saver) {
        ArrayList list = new ArrayList();
        for (Map.Entry entry : (Collection)map.map(Map::entrySet, Multimap::entries)) {
            Object value = entry.getValue();
            ArrayList<String> itemData = new ArrayList<String>();
            List<String> keySet = keyWriter.apply(value);
            itemData.add(ConfigHelper.concatStringList(keySet));
            List<?> args = valueWriter.apply(value);
            if (args == null) continue;
            itemData.addAll(args);
            list.add(itemData);
        }
        saver.accept(list);
    }

    public static <T> Codec<Either<TagKey<T>, T>> tagOrBuiltinCodec(ResourceKey<Registry<T>> vanillaRegistry, DefaultedRegistry<T> forgeRegistry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> String.format("Not a tag key for builtin registry %s: %s", vanillaRegistry.location(), str));
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.create((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + String.valueOf(key.location())), (Codec)Codec.STRING.comapFlatMap(str -> {
            ResourceLocation itemLocation = ResourceLocation.parse((String)str);
            Optional obj = forgeRegistry.getOptional(itemLocation);
            if (obj.isEmpty()) {
                if (CompatManager.modLoaded(itemLocation.getNamespace())) {
                    ColdSweat.LOGGER.error("Error deserializing config: object \"{}\" does not exist", str);
                    return DataResult.error(() -> "Object does not exist");
                }
                return DataResult.success((Object)forgeRegistry.get(forgeRegistry.getDefaultKey()));
            }
            return DataResult.success(obj.get());
        }, obj -> {
            ResourceLocation itemLocation = forgeRegistry.getKey(obj);
            return itemLocation.toString();
        }));
    }

    public static <T> Codec<Either<TagKey<T>, Holder<T>>> tagOrHolderCodec(ResourceKey<Registry<T>> vanillaRegistry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> String.format("Not a tag key for dynamic holder registry %s: %s", vanillaRegistry.location(), str));
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.create((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + String.valueOf(key.location())), (Codec)Codec.STRING.comapFlatMap(str -> {
            RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
            if (registryAccess == null) {
                ColdSweat.LOGGER.error("Error deserializing config: registry access is null");
                return DataResult.error(() -> "Registry access is null");
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str);
            Registry registry = registryAccess.registry(vanillaRegistry).orElse(null);
            if (registry == null) {
                ColdSweat.LOGGER.error("Error deserializing config: registry \"{}\" does not exist", (Object)vanillaRegistry.location());
                return DataResult.error(() -> "Registry does not exist");
            }
            Optional holder = registry.getHolder(itemLocation);
            if (holder.isEmpty()) {
                if (CompatManager.modLoaded(itemLocation.getNamespace())) {
                    ColdSweat.LOGGER.error("Error deserializing config: object \"{}\" does not exist", str);
                    return DataResult.error(() -> "Object does not exist");
                }
                return DataResult.success((Object)Holder.Reference.createIntrusive((HolderOwner)new HolderOwner<T>(){}, registry.stream().findFirst().get()));
            }
            return DataResult.success((Object)((Holder.Reference)holder.get()));
        }, holder -> {
            RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
            if (registryAccess == null) {
                ColdSweat.LOGGER.error("Error serializing config: registry access is null");
                return "null";
            }
            Registry registry = registryAccess.registry(vanillaRegistry).orElse(null);
            if (registry == null) {
                ColdSweat.LOGGER.error("Error serializing config: registry \"{}\" does not exist", (Object)vanillaRegistry.location());
                return "null";
            }
            return registry.getKey(holder.value()).toString();
        }));
    }

    public static <T> Codec<Either<TagKey<T>, Holder<T>>> tagOrBuiltinHolderCodec(ResourceKey<Registry<T>> vanillaRegistry, Registry<T> registry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> String.format("Not a tag key for builtin holder registry %s: %s", vanillaRegistry.location(), str));
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.create((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + String.valueOf(key.location())), (Codec)Codec.STRING.comapFlatMap(str -> {
            ResourceLocation itemLocation = ResourceLocation.parse((String)str);
            Optional holder = registry.getHolder(itemLocation);
            if (holder.isEmpty()) {
                if (CompatManager.modLoaded(itemLocation.getNamespace())) {
                    ColdSweat.LOGGER.error("Error deserializing config: object \"{}\" does not exist", str);
                    return DataResult.error(() -> "Object does not exist");
                }
                return DataResult.success((Object)Holder.Reference.createIntrusive((HolderOwner)new HolderOwner<T>(){}, registry.stream().findFirst().get()));
            }
            return DataResult.success((Object)((Holder.Reference)registry.getHolder(itemLocation).get()));
        }, holder -> {
            ResourceLocation itemLocation = registry.getKey(holder.value());
            return itemLocation.toString();
        }));
    }

    public static <T> Codec<Either<TagKey<T>, Holder<T>>> tagOrHolderCodec(ResourceKey<Registry<T>> vanillaRegistry, Codec<Holder<T>> codec) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> "Not a tag key: " + str);
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.create((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + String.valueOf(key.location())), codec);
    }

    public static <T> Codec<Either<TagKey<T>, ResourceKey<T>>> tagOrResourceKeyCodec(ResourceKey<Registry<T>> vanillaRegistry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> String.format("Not a tag key for dynamic resource registry %s: %s", vanillaRegistry.location(), str));
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.create((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + String.valueOf(key.location())), (Codec)ResourceKey.codec(vanillaRegistry));
    }

    public static <T> String serializeTagOrResourceKey(Either<TagKey<T>, ResourceKey<T>> obj) {
        return (String)obj.map(tag -> "#" + String.valueOf(tag.location()), key -> key.location().toString());
    }

    public static <T> String serializeTagOrBuiltin(Registry<T> forgeRegistry, Either<TagKey<T>, T> obj) {
        return (String)obj.map(tag -> "#" + String.valueOf(tag.location()), regObj -> Optional.ofNullable(forgeRegistry.getKey(regObj)).map(ResourceLocation::toString).orElse(""));
    }

    public static <T> String serializeTagOrRegistryObject(ResourceKey<Registry<T>> registry, Either<TagKey<T>, T> obj, RegistryAccess registryAccess) {
        Registry reg = registryAccess.registryOrThrow(registry);
        return (String)obj.map(tag -> "#" + String.valueOf(tag.location()), regObj -> Optional.ofNullable(reg.getKey(regObj)).map(ResourceLocation::toString).orElse(""));
    }

    public static <T> String serializeTagOrRegistryObject(ResourceKey<Registry<T>> registry, Either<TagKey<T>, Holder<T>> obj) {
        RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
        if (registryAccess == null) {
            ColdSweat.LOGGER.error("Error serializing config: registry access is null");
            return null;
        }
        Registry reg = registryAccess.registry(registry).orElse(null);
        return (String)obj.map(tag -> "#" + String.valueOf(tag.location()), regObj -> reg.getKey(regObj.value()).toString());
    }

    public static <T> Either<TagKey<T>, ResourceKey<T>> deserializeTagOrResourceKey(ResourceKey<Registry<T>> registry, String key) {
        if (key.startsWith("#")) {
            ResourceLocation tagID = ResourceLocation.parse((String)key.replace("#", ""));
            return Either.left((Object)TagKey.create(registry, (ResourceLocation)tagID));
        }
        ResourceKey biomeKey = ResourceKey.create(registry, (ResourceLocation)ResourceLocation.parse((String)key));
        return Either.right((Object)biomeKey);
    }

    public static <T> Either<TagKey<T>, T> deserializeTagOrBuiltin(String tagOrRegistryObject, ResourceKey<Registry<T>> vanillaRegistry, Registry<T> forgeRegistry) {
        if (tagOrRegistryObject.startsWith("#")) {
            ResourceLocation tagID = ResourceLocation.parse((String)tagOrRegistryObject.replace("#", ""));
            return Either.left((Object)TagKey.create(vanillaRegistry, (ResourceLocation)tagID));
        }
        ResourceLocation id = ResourceLocation.parse((String)tagOrRegistryObject);
        Object obj = forgeRegistry.get(id);
        if (obj == null) {
            ColdSweat.LOGGER.error("Error deserializing config: object \"{}\" does not exist", (Object)tagOrRegistryObject);
            return null;
        }
        return Either.right((Object)obj);
    }

    public static <T> Either<TagKey<T>, Holder<T>> deserializeTagOrRegistryObject(String tagOrRegistryObject, ResourceKey<Registry<T>> vanillaRegistry) {
        if (tagOrRegistryObject.startsWith("#")) {
            ResourceLocation tagID = ResourceLocation.parse((String)tagOrRegistryObject.replace("#", ""));
            return Either.left((Object)TagKey.create(vanillaRegistry, (ResourceLocation)tagID));
        }
        RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
        if (registryAccess == null) {
            ColdSweat.LOGGER.error("Error deserializing config: registry access is null");
            return null;
        }
        Registry reg = registryAccess.registry(vanillaRegistry).orElse(null);
        if (reg == null) {
            ColdSweat.LOGGER.error("Error deserializing config: registry \"{}\" does not exist", (Object)vanillaRegistry.location());
            return null;
        }
        ResourceLocation id = ResourceLocation.parse((String)tagOrRegistryObject);
        Holder obj = reg.getHolder(id).orElse(null);
        if (obj == null) {
            ColdSweat.LOGGER.error("Error deserializing config: object \"{}\" does not exist", (Object)tagOrRegistryObject);
            return null;
        }
        return Either.right((Object)obj);
    }

    public static Optional<FuelData> findFirstFuelMatching(DynamicHolder<Multimap<Item, FuelData>> predicates, ItemStack stack) {
        for (FuelData predicate : predicates.get().get((Object)stack.getItem())) {
            if (!predicate.test(stack)) continue;
            return Optional.of(predicate);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> parseResource(ResourceManager resourceManager, ResourceLocation location, Codec<T> codec) {
        Optional optional;
        if (resourceManager == null) {
            return Optional.empty();
        }
        Resource resource = (Resource)resourceManager.getResource(location).orElseThrow();
        InputStreamReader reader = new InputStreamReader(resource.open(), StandardCharsets.UTF_8);
        try {
            JsonObject json = GsonHelper.parse((Reader)reader);
            optional = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                ColdSweat.LOGGER.error((Object)new RuntimeException("Failed to load JSON file: " + String.valueOf(location), e));
                return Optional.empty();
            }
        }
        ((Reader)reader).close();
        return optional;
    }

    public static String concatStringList(List<String> list) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static <T> List<String> getTaggableListStrings(List<Either<TagKey<T>, T>> list, ResourceKey<Registry<T>> registry) {
        RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
        if (registryAccess == null) {
            return List.of();
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (Either<TagKey<T>, T> entry : list) {
            strings.add(ConfigHelper.serializeTagOrRegistryObject(registry, entry, registryAccess));
        }
        return strings;
    }

    public static List<String> getModIDs(String[] ids) {
        ArrayList<String> modIDs = new ArrayList<String>();
        for (String id : ids) {
            String[] split = id.split(":");
            if (split.length <= 1) continue;
            modIDs.add(split[0].replace("#", ""));
        }
        return modIDs;
    }

    public static String getModID(String id) {
        String[] split = id.split(":");
        if (split.length > 1) {
            return split[0].replace("#", "");
        }
        return "";
    }

    public static <T> List<String> getModIDs(List<Either<TagKey<T>, T>> list, Registry<T> registry) {
        return list.stream().map(either -> (String)either.map(tag -> tag.location().getNamespace(), obj -> Optional.ofNullable(registry.getKey(obj)).map(ResourceLocation::getNamespace).orElse(""))).distinct().filter(s -> !s.isEmpty()).toList();
    }

    public static <T> List<String> getModIDs(List<Either<TagKey<T>, Holder<T>>> list) {
        ArrayList<String> mods = new ArrayList<String>();
        for (Either<TagKey<T>, Holder<T>> either : list) {
            mods.add((String)either.map(tag -> tag.location().getNamespace(), obj -> obj.unwrapKey().map(key -> key.location().getNamespace()).orElse("")));
        }
        return mods;
    }

    public static double doubleArg(List<?> entry, int index) {
        if (entry.size() <= index) {
            ColdSweat.LOGGER.error("Error parsing config: not enough arguments");
            return 0.0;
        }
        Object obj = entry.get(index);
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return number.doubleValue();
        }
        ColdSweat.LOGGER.error("Error parsing config: invalid double value \"{}\"", entry.get(index));
        return 0.0;
    }
}

