/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin_public;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class MixinItemTooltipAdditional {
    public static Multimap<Holder<Attribute>, AttributeModifier> INSULATION_MODIFIERS = new FastMultiMap<Holder<Attribute>, AttributeModifier>();
    public static Multimap<Holder<Attribute>, AttributeModifier> UNMET_MODIFIERS = new FastMultiMap<Holder<Attribute>, AttributeModifier>();
    public static EquipmentSlotGroup CURRENT_SLOT_QUERY = null;

    @SubscribeEvent
    public static void addModifiers(AddAttributeTooltipsEvent event) {
        ItemStack stack = event.getStack();
        for (InsulatorData data : ConfigSettings.INSULATING_ARMORS.get().get((Object)stack.getItem())) {
            for (Map.Entry entry : data.attributes().getMap().entries()) {
                Holder attribute = (Holder)entry.getKey();
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                event.addTooltipLines(new Component[]{TooltipHandler.getFormattedAttributeModifier((Holder<Attribute>)attribute, modifier.amount(), modifier.operation(), true, !TooltipHandler.passesRequirement(data))});
            }
        }
        ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> cap.getInsulation().stream().map(Pair::getFirst).forEach(item -> {
            for (InsulatorData insulator : ConfigSettings.INSULATION_ITEMS.get().get((Object)item.getItem())) {
                for (Map.Entry entry : insulator.attributes().getMap().entries()) {
                    Holder attribute = (Holder)entry.getKey();
                    AttributeModifier modifier = (AttributeModifier)entry.getValue();
                    event.addTooltipLines(new Component[]{TooltipHandler.getFormattedAttributeModifier((Holder<Attribute>)attribute, modifier.amount(), modifier.operation(), true, !TooltipHandler.passesRequirement(insulator))});
                }
            }
        }));
    }
}

