/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.mojang.serialization.DynamicOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.MissingObjectEvent;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class MixinLoadItemStack<T> {
    @Inject(method={"parse(Lnet/minecraft/core/HolderLookup$Provider;Lnet/minecraft/nbt/Tag;)Ljava/util/Optional;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void fixParsing(HolderLookup.Provider lookups, Tag tag, CallbackInfoReturnable<Optional<ItemStack>> cir) {
        if (((Optional)cir.getReturnValue()).isEmpty() && tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            String key = compound.getString("id");
            MissingObjectEvent event = new MissingObjectEvent(ResourceLocation.parse((String)key));
            NeoForge.EVENT_BUS.post(event);
            if (event.getRemappedKey() != null) {
                compound.putString("id", event.getRemappedKey().toString());
                Optional parsed = ItemStack.CODEC.parse((DynamicOps)lookups.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound).resultOrPartial(message -> ColdSweat.LOGGER.error("Tried to remap item {}, but failed: '{}'", (Object)key, message));
                cir.setReturnValue((Object)parsed);
            }
        }
    }
}

