/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public class MixinHeartRender {
    private static final ResourceLocation HEART_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/hearts_frozen.png");
    private static int HEART_INDEX = 0;

    @Surrogate
    @Inject(method={"renderHeart"}, at={@At(value="TAIL")}, cancellable=true)
    private void renderHeart(GuiGraphics guiGraphics, Gui.HeartType heartType, int x, int y, boolean hardcore, boolean halfHeart, boolean blink, CallbackInfo ci) {
        int v;
        int u;
        if (heartType == Gui.HeartType.CONTAINER) {
            ++HEART_INDEX;
        }
        double heartsFreezePercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (heartsFreezePercentage == 0.0 || player.hasEffect(ModEffects.GRACE)) {
            return;
        }
        if (player.hasEffect(ModEffects.ICE_RESISTANCE)) {
            return;
        }
        double temp = Overlays.BLEND_BODY_TEMP;
        float maxHealth = player.getMaxHealth();
        boolean isHardcore = player.level().getLevelData().isHardcore();
        float maxFrozenHealth = (float)CSMath.blend((double)maxHealth * heartsFreezePercentage, 0.0, Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0);
        if (maxFrozenHealth == 0.0f) {
            return;
        }
        int frozenHealth = (int)CSMath.blend(0.0, (double)maxHealth * heartsFreezePercentage, temp, -50.0, -100.0);
        int frozenHearts = Math.round((float)frozenHealth / 2.0f);
        boolean partialFrozen = frozenHealth % 2 == 1 && HEART_INDEX == frozenHearts;
        int n = u = isHardcore ? 7 : 0;
        int n2 = partialFrozen ? (halfHeart ? 21 : 14) : (v = halfHeart ? 7 : 0);
        if (HEART_INDEX <= frozenHearts) {
            if (heartType == Gui.HeartType.CONTAINER) {
                guiGraphics.blit(HEART_TEXTURE, x + 1, y + 1, 14.0f, (float)v, 7, 7, 21, 28);
            } else {
                guiGraphics.blit(HEART_TEXTURE, x + 1, y + 1, (float)u, (float)v, 7, 7, 21, 28);
            }
        }
    }

    @Inject(method={"renderHearts"}, at={@At(value="HEAD")})
    private void renderHearts(GuiGraphics pGuiGraphics, Player pPlayer, int pX, int pY, int pHeight, int pOffsetHeartIndex, float pMaxHealth, int pCurrentHealth, int pDisplayHealth, int pAbsorptionAmount, boolean pRenderHighlight, CallbackInfo ci) {
        HEART_INDEX = 0;
    }
}

