/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.tag;

import com.momosoftworks.coldsweat.api.event.vanilla.ServerConfigsLoadedEvent;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

@EventBusSubscriber
public class ModDimensionTags {
    public static final TagKey<DimensionType> SOUL_LAMP_VALID = ModDimensionTags.createTag("soulspring_lamp_valid");
    public static final TagKey<DimensionType> HAS_CEILING = ModDimensionTags.createForgeTag("has_ceiling");
    public static final TagKey<DimensionType> HAS_SKY = ModDimensionTags.createForgeTag("has_sky");
    public static final TagKey<DimensionType> NATURAL = ModDimensionTags.createForgeTag("natural");
    public static final TagKey<DimensionType> UNNATURAL = ModDimensionTags.createForgeTag("unnatural");
    public static final TagKey<DimensionType> ULTRAWARM = ModDimensionTags.createForgeTag("ultrawarm");
    public static final TagKey<DimensionType> BED_WORKS = ModDimensionTags.createForgeTag("bed_works");
    public static final TagKey<DimensionType> RESPAWN_ANCHOR_WORKS = ModDimensionTags.createForgeTag("respawn_anchor_works");
    public static final TagKey<DimensionType> PIGLIN_SAFE = ModDimensionTags.createForgeTag("piglin_safe");
    public static final TagKey<DimensionType> HAS_SKYLIGHT = ModDimensionTags.createForgeTag("has_skylight");
    public static final TagKey<DimensionType> HAS_RAIDS = ModDimensionTags.createForgeTag("has_raids");
    public static final TagKey<DimensionType> OVERWORLD_LIKE = ModDimensionTags.createForgeTag("overworld_like");
    private static final Field CONTENTS = ObfuscationReflectionHelper.findField(HolderSet.Named.class, (String)"contents");
    private static final Method BIND = ObfuscationReflectionHelper.findMethod(HolderSet.Named.class, (String)"bind", (Class[])new Class[]{List.class});
    private static final Method BIND_TAGS = ObfuscationReflectionHelper.findMethod(Holder.Reference.class, (String)"bindTags", (Class[])new Class[]{Collection.class});

    private static TagKey<DimensionType> createTag(String name) {
        return TagKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)name));
    }

    private static TagKey<DimensionType> createForgeTag(String name) {
        return TagKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public static void initDynamicTags(RegistryAccess registryAccess) {
        ModDimensionTags.fillTag(HAS_CEILING, DimensionType::hasCeiling, registryAccess);
        ModDimensionTags.fillTag(HAS_SKY, dimensionType -> !dimensionType.hasCeiling(), registryAccess);
        ModDimensionTags.fillTag(NATURAL, DimensionType::natural, registryAccess);
        ModDimensionTags.fillTag(UNNATURAL, dimensionType -> !dimensionType.natural(), registryAccess);
        ModDimensionTags.fillTag(ULTRAWARM, DimensionType::ultraWarm, registryAccess);
        ModDimensionTags.fillTag(BED_WORKS, DimensionType::bedWorks, registryAccess);
        ModDimensionTags.fillTag(RESPAWN_ANCHOR_WORKS, DimensionType::respawnAnchorWorks, registryAccess);
        ModDimensionTags.fillTag(PIGLIN_SAFE, DimensionType::piglinSafe, registryAccess);
        ModDimensionTags.fillTag(HAS_SKYLIGHT, DimensionType::hasSkyLight, registryAccess);
        ModDimensionTags.fillTag(HAS_RAIDS, DimensionType::hasRaids, registryAccess);
        ModDimensionTags.fillTag(OVERWORLD_LIKE, dimensionType -> !dimensionType.hasCeiling() && dimensionType.natural() && dimensionType.hasSkyLight() && !dimensionType.ultraWarm(), registryAccess);
    }

    private static void fillTag(TagKey<DimensionType> tag, Predicate<DimensionType> predicate, RegistryAccess registryAccess) {
        Registry dimensionRegistry = registryAccess.registryOrThrow(Registries.DIMENSION_TYPE);
        HolderSet.Named holderSet = (HolderSet.Named)dimensionRegistry.getTag(tag).get();
        try {
            HashSet entries = new HashSet((List)CONTENTS.get(holderSet));
            dimensionRegistry.holders().forEach(dimensionType -> {
                if (predicate.test((DimensionType)dimensionType.value())) {
                    entries.add(dimensionType);
                    try {
                        BIND_TAGS.invoke(dimensionType, ListBuilder.begin(dimensionType.tags().toList()).add((List<TagKey>)tag).build());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            BIND.invoke((Object)holderSet, new ArrayList(entries));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void onServerStart(ServerConfigsLoadedEvent event) {
        ModDimensionTags.initDynamicTags((RegistryAccess)event.getServer().registryAccess());
    }

    static {
        CONTENTS.setAccessible(true);
        BIND.setAccessible(true);
        BIND_TAGS.setAccessible(true);
    }
}

