/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.loot;

import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class ModLootTables {
    public static final ResourceLocation GOAT_SHEARING = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"entities/goat_shearing");
    public static final ResourceLocation CHAMELEON_SHEDDING = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"entities/chameleon_shedding");
    public static final ResourceLocation CUSTOM_ICE_DROP = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"blocks/special/ice");
    public static final ResourceLocation CUSTOM_PACKED_ICE_DROP = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"blocks/special/packed_ice");
    public static final ResourceLocation CUSTOM_BLUE_ICE_DROP = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"blocks/special/blue_ice");

    public static List<ItemStack> getEntityDropsLootTable(Entity entity, @Nullable Player player, ResourceLocation lootTable) {
        LootParams lootContext = new LootParams.Builder((ServerLevel)entity.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)(player != null ? entity.damageSources().playerAttack(player) : entity.damageSources().generic())).withLuck(CSMath.getIfNotNull(player, Player::getLuck, Float.valueOf(0.0f)).floatValue()).create(LootContextParamSets.ENTITY);
        return entity.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable)).getRandomItems(lootContext);
    }

    public static List<ItemStack> getBlockDropsLootTable(ServerLevel level, BlockPos pos, BlockState state, @Nullable Player player, ResourceLocation lootTable) {
        LootParams lootContext = new LootParams.Builder(level).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.TOOL, (Object)CSMath.getIfNotNull(player, LivingEntity::getMainHandItem, ItemStack.EMPTY)).withParameter(LootContextParams.ORIGIN, (Object)pos.getCenter()).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).withLuck(CSMath.getIfNotNull(player, Player::getLuck, Float.valueOf(0.0f)).floatValue()).create(LootContextParamSets.BLOCK);
        return level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable)).getRandomItems(lootContext);
    }
}

