/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.world.entity.EquipmentSlot;

public class ExtraCodecs {
    public static final Codec<EquipmentSlot> EQUIPMENT_SLOT = Codec.STRING.xmap(EquipmentSlot::byName, EquipmentSlot::getName);

    public static Codec<Object> anyOf(final Codec<?> ... codecs) {
        return new Codec<Object>(){

            public <T> DataResult<T> encode(Object input, DynamicOps<T> ops, T prefix) {
                for (Codec codec : codecs) {
                    try {
                        DataResult result = codec.encode(input, ops, prefix);
                        if (!result.result().isPresent()) continue;
                        return result;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                return DataResult.error(() -> "No codecs could encode input " + String.valueOf(input));
            }

            public <T> DataResult<Pair<Object, T>> decode(DynamicOps<T> ops, T input) {
                for (Codec codec : codecs) {
                    DataResult result = codec.decode(ops, input);
                    if (!result.result().isPresent()) continue;
                    return result;
                }
                return DataResult.error(() -> "No codecs could decode input " + String.valueOf(input));
            }
        };
    }
}

