/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record DoubleBounds(double min, double max) {
    public static final Codec<DoubleBounds> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("min", (Object)Double.NEGATIVE_INFINITY).forGetter(bounds -> bounds.min), (App)Codec.DOUBLE.optionalFieldOf("max", (Object)Double.POSITIVE_INFINITY).forGetter(bounds -> bounds.max)).apply((Applicative)instance, DoubleBounds::new));
    public static final Codec<DoubleBounds> CODEC = Codec.either(DIRECT_CODEC, (Codec)Codec.DOUBLE).xmap(either -> (DoubleBounds)either.map(left -> left, right -> new DoubleBounds((double)right, (double)right)), bounds -> bounds.max == bounds.min ? Either.right((Object)bounds.min) : Either.left((Object)bounds));
    public static final StreamCodec<FriendlyByteBuf, DoubleBounds> STREAM_CODEC = StreamCodec.of((buf, bounds) -> {
        buf.writeDouble(bounds.min());
        buf.writeDouble(bounds.max());
    }, buf -> new DoubleBounds(buf.readInt(), buf.readInt()));
    public static DoubleBounds NONE = new DoubleBounds(-2.147483647E9, 2.147483647E9);

    public DoubleBounds(Double[] bounds) {
        this(bounds[0], bounds[1]);
    }

    public boolean test(double value) {
        return value >= this.min && value <= this.max;
    }

    public boolean contains(DoubleBounds bounds) {
        return bounds.min >= this.min && bounds.max <= this.max;
    }

    public double getRandom() {
        return this.min + Math.random() * (this.max - this.min);
    }

    public double clamp(double value) {
        return CSMath.clamp(value, this.min, this.max);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleBounds that = (DoubleBounds)obj;
        if (!Objects.equals(this.min, that.min)) {
            return false;
        }
        return Objects.equals(this.max, that.max);
    }
}

