/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class CommonStreamCodecs {
    public static final StreamCodec<FriendlyByteBuf, Double> DOUBLE = StreamCodec.of(FriendlyByteBuf::writeDouble, FriendlyByteBuf::readDouble);

    public static <T, B extends FriendlyByteBuf> StreamCodec<B, Collection<T>> listCodec(StreamCodec<B, T> elementCodec) {
        return StreamCodec.of((buf, list) -> {
            buf.writeVarInt(list.size());
            list.forEach(element -> elementCodec.encode(buf, element));
        }, buf -> {
            int size = buf.readVarInt();
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                list.add(elementCodec.decode(buf));
            }
            return list;
        });
    }

    public static <T> StreamCodec<FriendlyByteBuf, TagKey<T>> tagKeyCodec(ResourceKey<? extends Registry<T>> key) {
        return StreamCodec.of((buf, tagkey) -> {
            buf.writeResourceKey(tagkey.registry());
            buf.writeResourceLocation(tagkey.location());
        }, buf -> {
            ResourceKey registry = buf.readResourceKey(key).registryKey();
            ResourceLocation location = buf.readResourceLocation();
            return TagKey.create((ResourceKey)registry, (ResourceLocation)location);
        });
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Either<TagKey<T>, T>> tagOrRegistryCodec(ResourceKey<? extends Registry<T>> key) {
        return StreamCodec.of((buf, either) -> {
            buf.writeBoolean(either.left().isPresent());
            either.ifLeft(tag -> buf.writeUtf(tag.location().toString())).ifRight(reg -> ByteBufCodecs.registry((ResourceKey)key).encode(buf, reg));
        }, buf -> {
            if (buf.readBoolean()) {
                return Either.left((Object)TagKey.create((ResourceKey)key, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf())));
            }
            return Either.right((Object)ByteBufCodecs.registry((ResourceKey)key).decode(buf));
        });
    }

    public static <T, B extends FriendlyByteBuf> Optional<T> readOptional(B buf, StreamDecoder<B, T> reader) {
        if (buf.readBoolean()) {
            return Optional.of(reader.decode(buf));
        }
        return Optional.empty();
    }

    public static <T, B extends FriendlyByteBuf> void writeOptional(B buf, Optional<T> optional, StreamEncoder<B, T> writer) {
        if (optional.isPresent()) {
            buf.writeBoolean(true);
            writer.encode(buf, optional.get());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static <T, B extends FriendlyByteBuf> Optional<List<T>> readOptionalList(B buf, StreamDecoder<B, T> reader) {
        if (buf.readBoolean()) {
            int size = buf.readVarInt();
            ArrayList<Object> collection = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                collection.add(reader.decode(buf));
            }
            return Optional.of(collection);
        }
        return Optional.empty();
    }

    public static <T, B extends FriendlyByteBuf> void writeOptionalList(B buf, Optional<? extends List<T>> optional, StreamEncoder<B, T> writer) {
        if (optional.isPresent()) {
            List<T> collection = optional.get();
            buf.writeBoolean(true);
            buf.writeVarInt(optional.get().size());
            for (T t : collection) {
                writer.encode(buf, t);
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public static <T, B extends FriendlyByteBuf> void writeList(B buf, Collection<T> collection, StreamEncoder<B, T> writer) {
        buf.writeVarInt(collection.size());
        for (T t : collection) {
            writer.encode(buf, t);
        }
    }

    public static <T, B extends FriendlyByteBuf> List<T> readList(B buf, StreamDecoder<B, T> reader) {
        int size = buf.readVarInt();
        ArrayList<Object> collection = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            collection.add(reader.decode(buf));
        }
        return collection;
    }

    public static <K, V, U extends FriendlyByteBuf, W extends FriendlyByteBuf> void writeMap(FriendlyByteBuf buf, Map<K, V> map, StreamEncoder<U, ? super K> keyWriter, StreamEncoder<W, ? super V> valueWriter) {
        buf.writeVarInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keyWriter.encode((Object)buf, entry.getKey());
            valueWriter.encode((Object)buf, entry.getValue());
        }
    }

    public static <K, V, U extends FriendlyByteBuf, W extends FriendlyByteBuf> Map<K, V> readMap(FriendlyByteBuf buf, StreamDecoder<U, K> keyReader, StreamDecoder<W, V> valueReader) {
        int size = buf.readVarInt();
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = keyReader.decode((Object)buf);
            Object value = valueReader.decode((Object)buf);
            map.put(key, value);
        }
        return map;
    }
}

