/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeCodecs {
    public static Codec<AttributeModifier.Operation> OPERATION_CODEC = Codec.STRING.xmap(string -> AttributeModifier.Operation.valueOf((String)string.toUpperCase(Locale.ROOT)), operation -> operation.name().toLowerCase(Locale.ROOT));
    public static Codec<AttributeModifier> MODIFIER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("name").forGetter(AttributeModifier::id), (App)Codec.DOUBLE.fieldOf("amount").forGetter(AttributeModifier::amount), (App)OPERATION_CODEC.fieldOf("operation").forGetter(AttributeModifier::operation)).apply((Applicative)instance, AttributeModifier::new));
    public static final StreamCodec<FriendlyByteBuf, AttributeModifier> MODIFIER_STREAM_CODEC = StreamCodec.of((buf, modifier) -> {
        buf.writeResourceLocation(modifier.id());
        buf.writeDouble(modifier.amount());
        buf.writeEnum((Enum)modifier.operation());
    }, buf -> new AttributeModifier(buf.readResourceLocation(), buf.readDouble(), (AttributeModifier.Operation)buf.readEnum(AttributeModifier.Operation.class)));
    public static Codec<Attribute> ATTRIBUTE_CODEC = ResourceLocation.CODEC.xmap(arg_0 -> ((Registry)BuiltInRegistries.ATTRIBUTE).get(arg_0), arg_0 -> ((Registry)BuiltInRegistries.ATTRIBUTE).getKey(arg_0));
}

