/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.FluidRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.WorldTempBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public record LocationRequirement(Optional<IntegerBounds> x, Optional<IntegerBounds> y, Optional<IntegerBounds> z, int xOffset, int yOffset, int zOffset, Optional<Either<TagKey<Biome>, ResourceKey<Biome>>> biome, Optional<Either<TagKey<Structure>, ResourceKey<Structure>>> structure, Optional<Either<TagKey<Level>, ResourceKey<Level>>> dimension, Optional<IntegerBounds> light, Optional<BlockRequirement> block, Optional<FluidRequirement> fluid, Optional<WorldTempBounds> temperature, Optional<Predicate<BlockInWorld>> predicate) {
    public static final Codec<LocationRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntegerBounds.CODEC.optionalFieldOf("x").forGetter(location -> location.x), (App)IntegerBounds.CODEC.optionalFieldOf("y").forGetter(location -> location.y), (App)IntegerBounds.CODEC.optionalFieldOf("z").forGetter(location -> location.z), (App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(location -> location.xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(location -> location.yOffset), (App)Codec.INT.optionalFieldOf("z_offset", (Object)0).forGetter(location -> location.zOffset), (App)ConfigHelper.tagOrResourceKeyCodec(Registries.BIOME).optionalFieldOf("biome").forGetter(location -> location.biome), (App)ConfigHelper.tagOrResourceKeyCodec(Registries.STRUCTURE).optionalFieldOf("structure").forGetter(location -> location.structure), (App)ConfigHelper.tagOrResourceKeyCodec(Registries.DIMENSION).optionalFieldOf("dimension").forGetter(location -> location.dimension), (App)IntegerBounds.CODEC.optionalFieldOf("light").forGetter(location -> location.light), (App)BlockRequirement.CODEC.optionalFieldOf("block").forGetter(location -> location.block), (App)FluidRequirement.CODEC.optionalFieldOf("fluid").forGetter(location -> location.fluid), (App)WorldTempBounds.CODEC.optionalFieldOf("temperature").forGetter(location -> location.temperature)).apply((Applicative)instance, LocationRequirement::new));
    public static final LocationRequirement NONE = new LocationRequirement(Optional.empty(), Optional.empty(), Optional.empty(), 0, 0, 0, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());

    public LocationRequirement(Optional<IntegerBounds> x, Optional<IntegerBounds> y, Optional<IntegerBounds> z, int xOffset, int yOffset, int zOffset, Optional<Either<TagKey<Biome>, ResourceKey<Biome>>> biome, Optional<Either<TagKey<Structure>, ResourceKey<Structure>>> structure, Optional<Either<TagKey<Level>, ResourceKey<Level>>> dimension, Optional<IntegerBounds> light, Optional<BlockRequirement> block, Optional<FluidRequirement> fluid, Optional<WorldTempBounds> temperature) {
        this(x, y, z, xOffset, yOffset, zOffset, biome, structure, dimension, light, block, fluid, temperature, Optional.empty());
    }

    public LocationRequirement(Predicate<BlockInWorld> predicate) {
        this(Optional.empty(), Optional.empty(), Optional.empty(), 0, 0, 0, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(predicate));
    }

    public boolean test(Level level, Vec3 pos) {
        return this.test(level, BlockPos.containing((Position)pos));
    }

    public boolean test(Level level, BlockPos origin) {
        int light;
        if (this.predicate.isPresent()) {
            return this.predicate.get().test(new BlockInWorld((LevelReader)level, origin, true));
        }
        BlockPos.MutableBlockPos pos = origin.mutable();
        pos.move(this.xOffset, this.yOffset, this.zOffset);
        if (!this.x.map(range -> range.test(pos.getX())).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.y.map(range -> range.test(pos.getY())).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.z.map(range -> range.test(pos.getZ())).orElse(true).booleanValue()) {
            return false;
        }
        if (this.dimension.isPresent() && !((Boolean)this.dimension.get().map(tag -> level.dimensionTypeRegistration().is(tag.location()), key -> level.dimension().equals(key))).booleanValue()) {
            return false;
        }
        if (this.biome.isPresent() && !((Boolean)this.biome.get().map(tag -> level.getBiomeManager().getNoiseBiomeAtPosition((BlockPos)pos).is(tag), key -> level.getBiomeManager().getNoiseBiomeAtPosition((BlockPos)pos).is(key))).booleanValue()) {
            return false;
        }
        if (this.structure.isPresent()) {
            StructureManager structureManager = WorldHelper.getServerLevel(level).structureManager();
            StructureStart structureStart = (StructureStart)this.structure.get().map(tag -> structureManager.getStructureWithPieceAt((BlockPos)pos, tag), key -> structureManager.getStructureWithPieceAt((BlockPos)pos, (Structure)level.registryAccess().registryOrThrow(Registries.STRUCTURE).get(key)));
            if (structureStart == null || structureStart == StructureStart.INVALID_START) {
                return false;
            }
        }
        if (this.light.isPresent() && ((light = level.getMaxLocalRawBrightness((BlockPos)pos)) < this.light.get().min() || light > this.light.get().max())) {
            return false;
        }
        if (this.block.isPresent() && !this.block.get().test(level, (BlockPos)pos)) {
            return false;
        }
        if (this.fluid.isPresent() && !this.fluid.get().test(level, (BlockPos)pos)) {
            return false;
        }
        return !this.temperature.isPresent() || this.temperature.get().test(WorldHelper.getRoughTemperatureAt(level, (BlockPos)pos));
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocationRequirement that = (LocationRequirement)obj;
        return this.x.equals(that.x) && this.y.equals(that.y) && this.z.equals(that.z) && this.biome.equals(that.biome) && this.structure.equals(that.structure) && this.dimension.equals(that.dimension) && this.light.equals(that.light) && this.block.equals(that.block) && this.fluid.equals(that.fluid);
    }
}

