/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.EnchantmentRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemComponentsRequirement;
import com.momosoftworks.coldsweat.data.codec.util.CommonStreamCodecs;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public record ItemRequirement(List<Either<TagKey<Item>, Item>> items, Optional<IntegerBounds> count, Optional<IntegerBounds> durability, Optional<List<EnchantmentRequirement>> enchantments, Optional<Potion> potion, ItemComponentsRequirement components, Optional<Predicate<ItemStack>> predicate) {
    public static final Codec<ItemRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.tagOrBuiltinCodec(Registries.ITEM, BuiltInRegistries.ITEM).listOf().optionalFieldOf("items", List.of()).forGetter(predicate -> predicate.items), (App)IntegerBounds.CODEC.optionalFieldOf("count").forGetter(predicate -> predicate.count), (App)IntegerBounds.CODEC.optionalFieldOf("durability").forGetter(predicate -> predicate.durability), (App)EnchantmentRequirement.CODEC.listOf().optionalFieldOf("enchantments").forGetter(predicate -> predicate.enchantments), (App)BuiltInRegistries.POTION.byNameCodec().optionalFieldOf("potion").forGetter(predicate -> predicate.potion), (App)ItemComponentsRequirement.CODEC.optionalFieldOf("components", (Object)new ItemComponentsRequirement()).forGetter(predicate -> predicate.components)).apply((Applicative)instance, ItemRequirement::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemRequirement> STREAM_CODEC = StreamCodec.of((buf, predicate) -> {
        CommonStreamCodecs.writeList(buf, predicate.items, CommonStreamCodecs.tagOrRegistryCodec(Registries.ITEM));
        buf.writeOptional(predicate.count, IntegerBounds.STREAM_CODEC);
        buf.writeOptional(predicate.durability, IntegerBounds.STREAM_CODEC);
        CommonStreamCodecs.writeOptionalList(buf, predicate.enchantments, EnchantmentRequirement.STREAM_CODEC);
        CommonStreamCodecs.writeOptional(buf, predicate.potion, ByteBufCodecs.registry((ResourceKey)Registries.POTION));
        ItemComponentsRequirement.STREAM_CODEC.encode(buf, (Object)predicate.components);
    }, buf -> {
        List<Either<TagKey<Item>, Item>> items = CommonStreamCodecs.readList(buf, CommonStreamCodecs.tagOrRegistryCodec(Registries.ITEM));
        Optional count = buf.readOptional(IntegerBounds.STREAM_CODEC);
        Optional durability = buf.readOptional(IntegerBounds.STREAM_CODEC);
        Optional<List<EnchantmentRequirement>> enchantments = CommonStreamCodecs.readOptionalList(buf, EnchantmentRequirement.STREAM_CODEC);
        Optional<Potion> potion = CommonStreamCodecs.readOptional(buf, ByteBufCodecs.registry((ResourceKey)Registries.POTION));
        ItemComponentsRequirement components = (ItemComponentsRequirement)ItemComponentsRequirement.STREAM_CODEC.decode(buf);
        return new ItemRequirement(items, count, durability, enchantments, potion, components);
    });
    public static final ItemRequirement NONE = new ItemRequirement(List.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new ItemComponentsRequirement());

    public ItemRequirement(List<Either<TagKey<Item>, Item>> items, Optional<IntegerBounds> count, Optional<IntegerBounds> durability, Optional<List<EnchantmentRequirement>> enchantments, Optional<Potion> potion, ItemComponentsRequirement components) {
        this(items, count, durability, enchantments, potion, components, Optional.empty());
    }

    public ItemRequirement(List<Either<TagKey<Item>, Item>> items, ItemComponentsRequirement components) {
        this(items, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), components);
    }

    public ItemRequirement(Collection<Item> items, @Nullable Predicate<ItemStack> predicate) {
        this(items.stream().map(Either::right).toList(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new ItemComponentsRequirement(), Optional.ofNullable(predicate));
    }

    public ItemRequirement(Predicate<ItemStack> predicate) {
        this(List.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new ItemComponentsRequirement(), Optional.of(predicate));
    }

    public boolean test(ItemStack stack, boolean ignoreCount) {
        block12: {
            if (stack.isEmpty() && !this.items.isEmpty()) {
                return false;
            }
            if (!this.items.isEmpty()) {
                for (int i = 0; i < this.items.size(); ++i) {
                    Either<TagKey<Item>, Item> either = this.items.get(i);
                    if (!((Boolean)either.map(arg_0 -> ((ItemStack)stack).is(arg_0), arg_0 -> ((ItemStack)stack).is(arg_0))).booleanValue()) {
                        continue;
                    }
                    break block12;
                }
                return false;
            }
        }
        if (this.predicate.isPresent()) {
            return this.predicate.get().test(stack);
        }
        if (!this.components.test(stack.getComponents())) {
            return false;
        }
        if (!ignoreCount && this.count.isPresent() && !this.count.get().test(stack.getCount())) {
            return false;
        }
        if (this.durability.isPresent() && !this.durability.get().test(stack.getMaxDamage() - stack.getDamageValue())) {
            return false;
        }
        if (this.potion.isPresent() && !this.potion.get().getEffects().equals(((Potion)((Holder)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.AWKWARD))).potion().get()).value()).getEffects())) {
            return false;
        }
        if (!this.components.test(stack.getComponents())) {
            return false;
        }
        if (this.enchantments.isPresent()) {
            ItemEnchantments stackEnchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            stackEnchantments.entrySet().addAll(((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).entrySet());
            for (EnchantmentRequirement enchantment : this.enchantments.get()) {
                if (enchantment.test(stackEnchantments)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemRequirement that = (ItemRequirement)obj;
        return this.items.equals(that.items) && this.count.equals(that.count) && this.durability.equals(that.durability) && this.enchantments.equals(that.enchantments) && this.potion.equals(that.potion) && this.components.equals(that.components) && this.predicate.equals(that.predicate);
    }
}

