/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public record FluidRequirement(Optional<List<Either<TagKey<Fluid>, Fluid>>> fluids, Optional<TagKey<Fluid>> tag, Optional<BlockRequirement.StateRequirement> state, Optional<NbtRequirement> nbt) {
    public static final Codec<FluidRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)ConfigHelper.tagOrBuiltinCodec(Registries.FLUID, BuiltInRegistries.FLUID).listOf(), ConfigHelper.tagOrBuiltinCodec(Registries.FLUID, BuiltInRegistries.FLUID)).xmap(either -> (List)either.map(l -> l, r -> List.of(r)), either -> either.size() == 1 ? Either.right((Object)((Either)either.get(0))) : Either.left((Object)either)).optionalFieldOf("fluids").forGetter(predicate -> predicate.fluids), (App)TagKey.codec((ResourceKey)Registries.FLUID).optionalFieldOf("tag").forGetter(predicate -> predicate.tag), (App)BlockRequirement.StateRequirement.CODEC.optionalFieldOf("state").forGetter(predicate -> predicate.state), (App)NbtRequirement.CODEC.optionalFieldOf("nbt").forGetter(predicate -> predicate.nbt)).apply((Applicative)instance, FluidRequirement::new));

    public boolean test(Level level, BlockPos pos) {
        if (!level.isLoaded(pos)) {
            return false;
        }
        FluidState flState = level.getFluidState(pos);
        if (this.tag.isPresent() && !flState.is(this.tag.get())) {
            return false;
        }
        if (this.fluids.isPresent() && !RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.FLUID, this.fluids.get()).contains(flState.getType())) {
            return false;
        }
        return this.state.isEmpty() || this.state.get().test(flState);
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FluidRequirement that = (FluidRequirement)obj;
        return this.fluids.equals(that.fluids) && this.tag.equals(that.tag) && this.state.equals(that.state) && this.nbt.equals(that.nbt);
    }
}

