/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public record EnchantmentRequirement(Either<TagKey<Enchantment>, Holder<Enchantment>> enchantment, Optional<IntegerBounds> level) {
    public static final Codec<EnchantmentRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.tagOrHolderCodec(Registries.ENCHANTMENT).fieldOf("enchantment").forGetter(requirement -> requirement.enchantment), (App)IntegerBounds.CODEC.optionalFieldOf("levels").forGetter(requirement -> requirement.level)).apply((Applicative)instance, EnchantmentRequirement::new));
    public static StreamCodec<RegistryFriendlyByteBuf, EnchantmentRequirement> STREAM_CODEC = StreamCodec.of((buf, requirement) -> {
        buf.writeUtf(ConfigHelper.serializeTagOrRegistryObject(Registries.ENCHANTMENT, requirement.enchantment));
        buf.writeOptional(requirement.level, IntegerBounds.STREAM_CODEC);
    }, buf -> new EnchantmentRequirement(ConfigHelper.deserializeTagOrRegistryObject(buf.readUtf(), Registries.ENCHANTMENT), buf.readOptional(IntegerBounds.STREAM_CODEC)));

    public boolean test(Holder<Enchantment> enchantment, int level) {
        return (Boolean)this.enchantment.map(tag -> enchantment.is(tag), ench -> ench == enchantment) != false && this.level.map(bounds -> bounds.test(level)).orElse(true) != false;
    }

    public boolean test(ItemEnchantments enchantments) {
        for (Object2IntMap.Entry entry : enchantments.entrySet()) {
            if (!this.test((Holder<Enchantment>)((Holder)entry.getKey()), entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EnchantmentRequirement that = (EnchantmentRequirement)obj;
        return this.enchantment.equals(that.enchantment) && this.level.equals(that.level);
    }
}

