/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.api.annotation.Internal;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;

public abstract class ConfigData
implements NbtSerializable {
    private UUID id = UUID.randomUUID();
    private Type registryType;
    NegatableList<String> requiredMods;

    public ConfigData(NegatableList<String> requiredMods) {
        this.requiredMods = requiredMods;
    }

    public abstract Codec<? extends ConfigData> getCodec();

    public UUID uuid() {
        return this.id;
    }

    public Type registryType() {
        return this.registryType;
    }

    public NegatableList<String> requiredMods() {
        return this.requiredMods;
    }

    @Internal
    public void setId(UUID id) {
        this.id = id;
    }

    @Internal
    public void setRegistryType(Type registryType) {
        this.registryType = registryType;
    }

    @Override
    public CompoundTag serialize() {
        return this.getCodec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).result().orElse(new CompoundTag());
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.valueOf(this.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse(""));
    }

    public boolean areRequiredModsLoaded() {
        return this.requiredMods.test(mod -> mod.equals("minecraft") || CompatManager.modLoaded(mod));
    }

    public boolean equals(Object obj) {
        ConfigData data;
        return obj instanceof ConfigData && (data = (ConfigData)obj).requiredMods().equals(this.requiredMods());
    }

    public static enum Type {
        TOML,
        JSON,
        KUBEJS;

    }
}

