/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RemoveRegistryData<T extends ConfigData>
extends ConfigData {
    private final ResourceKey<Registry<T>> registry;
    private final NegatableList<CompoundTag> matches;
    private final List<ResourceLocation> entries;
    public static final Codec<RemoveRegistryData<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(s -> ModRegistries.getRegistry(s), key -> ModRegistries.getRegistryName((ResourceKey<? extends ConfigData>)key)).fieldOf("registry").forGetter(data -> data.registry()), (App)NegatableList.codec(CompoundTag.CODEC).fieldOf("matches").forGetter(data -> data.matches), (App)ResourceLocation.CODEC.listOf().fieldOf("entries").forGetter(data -> data.entries)).apply((Applicative)instance, RemoveRegistryData::new));

    public RemoveRegistryData(ResourceKey<Registry<T>> registry, NegatableList<CompoundTag> matches, List<ResourceLocation> entries) {
        super(new NegatableList<String>());
        this.registry = registry;
        this.matches = matches;
        this.entries = entries;
    }

    public ResourceKey<Registry<T>> registry() {
        return this.registry;
    }

    public NegatableList<CompoundTag> matches() {
        return this.matches;
    }

    public List<ResourceLocation> entries() {
        return this.entries;
    }

    public boolean matches(T object) {
        Optional serializedOpt = ModRegistries.getCodec(this.registry).encodeStart((DynamicOps)NbtOps.INSTANCE, object).result();
        return serializedOpt.map(serialized -> this.matches.test(nbt -> NbtRequirement.compareNbt((Tag)nbt, serialized, true))).orElse(false);
    }

    @Override
    public Codec<? extends ConfigData> getCodec() {
        return CODEC;
    }
}

