/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemComponentsRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.data.codec.util.CommonStreamCodecs;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InsulatorData
extends ConfigData
implements RequirementHolder {
    final NegatableList<ItemRequirement> item;
    final Insulation.Slot slot;
    final List<Insulation> insulation;
    final NegatableList<EntityRequirement> entity;
    final AttributeModifierMap attributes;
    final Map<ResourceLocation, Double> immuneTempModifiers;
    final boolean fillSlots;
    private static final Codec<List<Insulation>> INSULATION_CODEC = Codec.either((Codec)Insulation.getCodec().listOf(), Insulation.getCodec()).xmap(either -> (List)either.map(left -> left.stream().filter(insul -> !insul.isEmpty()).toList(), right -> right.isEmpty() ? List.of() : List.of(right)), list -> list.size() == 1 ? Either.right((Object)((Insulation)list.get(0))) : Either.left((Object)list));
    public static final Codec<InsulatorData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.codec(ItemRequirement.CODEC).optionalFieldOf("item", new NegatableList()).forGetter(InsulatorData::item), (App)Insulation.Slot.CODEC.fieldOf("type").forGetter(InsulatorData::slot), (App)INSULATION_CODEC.fieldOf("insulation").forGetter(InsulatorData::insulation), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("entity", new NegatableList()).forGetter(InsulatorData::entity), (App)AttributeModifierMap.CODEC.optionalFieldOf("attributes", (Object)new AttributeModifierMap()).forGetter(InsulatorData::attributes), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.DOUBLE).optionalFieldOf("immune_temp_modifiers", new HashMap()).forGetter(InsulatorData::immuneTempModifiers), (App)Codec.BOOL.optionalFieldOf("fill_slots", (Object)false).forGetter(InsulatorData::fillSlots), (App)NegatableList.listCodec(Codec.STRING).optionalFieldOf("required_mods", new NegatableList()).forGetter(ConfigData::requiredMods)).apply((Applicative)instance, InsulatorData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, InsulatorData> STREAM_CODEC = StreamCodec.of((buf, insulator) -> {
        NegatableList.streamCodec(ItemRequirement.STREAM_CODEC).encode(buf, insulator.item());
        buf.writeCollection(insulator.insulation(), Insulation.getNetworkCodec());
        buf.writeEnum((Enum)insulator.slot());
        buf.writeNbt((Tag)NegatableList.codec(EntityRequirement.getCodec()).encode(insulator.entity(), (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).result().orElse(new CompoundTag()));
        AttributeModifierMap.STREAM_CODEC.encode(buf, (Object)insulator.attributes());
        buf.writeMap(insulator.immuneTempModifiers(), (StreamEncoder)ResourceLocation.STREAM_CODEC, CommonStreamCodecs.DOUBLE);
        buf.writeBoolean(insulator.fillSlots());
    }, buf -> {
        NegatableList item = (NegatableList)NegatableList.streamCodec(ItemRequirement.STREAM_CODEC).decode(buf);
        List insulation = (List)buf.readCollection(ArrayList::new, Insulation.getNetworkCodec());
        Insulation.Slot slot = (Insulation.Slot)buf.readEnum(Insulation.Slot.class);
        NegatableList predicate = (NegatableList)NegatableList.codec(EntityRequirement.getCodec()).decode((DynamicOps)NbtOps.INSTANCE, (Object)buf.readNbt()).result().orElse(Pair.of(new NegatableList(), (Object)new CompoundTag())).getFirst();
        AttributeModifierMap attributes = (AttributeModifierMap)AttributeModifierMap.STREAM_CODEC.decode(buf);
        Map immuneTempModifiers = buf.readMap((StreamDecoder)ResourceLocation.STREAM_CODEC, CommonStreamCodecs.DOUBLE);
        boolean multiSlot = buf.readBoolean();
        return new InsulatorData(item, slot, insulation, predicate, attributes, immuneTempModifiers, multiSlot);
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, InsulatorData> SIMPLE_STREAM_CODEC = StreamCodec.of((buf, insulator) -> {
        buf.writeEnum((Enum)insulator.slot());
        buf.writeCollection(insulator.insulation(), Insulation.getNetworkCodec());
        buf.writeBoolean(insulator.fillSlots());
    }, buf -> {
        Insulation.Slot slot = (Insulation.Slot)buf.readEnum(Insulation.Slot.class);
        List insulation = (List)buf.readCollection(ArrayList::new, Insulation.getNetworkCodec());
        boolean multiSlot = buf.readBoolean();
        return new InsulatorData(new NegatableList<ItemRequirement>(), slot, insulation, new NegatableList<EntityRequirement>(), new AttributeModifierMap(), new HashMap<ResourceLocation, Double>(), multiSlot);
    });

    public InsulatorData(NegatableList<ItemRequirement> item, Insulation.Slot slot, List<Insulation> insulation, NegatableList<EntityRequirement> entity, AttributeModifierMap attributes, Map<ResourceLocation, Double> immuneTempModifiers, boolean fillSlots, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.item = item;
        this.slot = slot;
        this.insulation = insulation;
        this.entity = entity;
        this.attributes = attributes;
        this.immuneTempModifiers = immuneTempModifiers;
        this.fillSlots = fillSlots;
    }

    public InsulatorData(NegatableList<ItemRequirement> item, Insulation.Slot slot, List<Insulation> insulation, NegatableList<EntityRequirement> entity, AttributeModifierMap attributes, Map<ResourceLocation, Double> immuneTempModifiers, boolean fillSlots) {
        this(item, slot, insulation, entity, attributes, immuneTempModifiers, fillSlots, new NegatableList<String>());
    }

    public NegatableList<ItemRequirement> item() {
        return this.item;
    }

    public Insulation.Slot slot() {
        return this.slot;
    }

    public List<Insulation> insulation() {
        return this.insulation;
    }

    public NegatableList<EntityRequirement> entity() {
        return this.entity;
    }

    public AttributeModifierMap attributes() {
        return this.attributes;
    }

    public Map<ResourceLocation, Double> immuneTempModifiers() {
        return this.immuneTempModifiers;
    }

    public boolean fillSlots() {
        return this.fillSlots;
    }

    public double getCold() {
        return this.insulation.stream().mapToDouble(Insulation::getCold).sum();
    }

    public double getHeat() {
        return this.insulation.stream().mapToDouble(Insulation::getHeat).sum();
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.item.test((T rq) -> rq.test(stack, true));
    }

    @Override
    public boolean test(Entity entity) {
        return entity == null || this.entity.test((T rq) -> rq.test(entity));
    }

    @Nullable
    public static InsulatorData fromToml(List<?> entry, Insulation.Slot slot) {
        if (entry.size() < 3) {
            ColdSweat.LOGGER.error("Error parsing {} insulator config: not enough arguments", (Object)slot.getSerializedName());
            return null;
        }
        List<Either<TagKey<Item>, Item>> items = ConfigHelper.getItems((String)entry.get(0));
        if (items.isEmpty()) {
            return null;
        }
        boolean adaptive = entry.size() > 3 && entry.get(3).equals("adaptive");
        ArrayList<Insulation> insulation = new ArrayList<Insulation>();
        if (!adaptive) {
            List list;
            Object obj;
            if (!(entry.get(1) instanceof Number || (obj = entry.get(1)) instanceof List && (list = (List)obj).stream().allMatch(val -> val instanceof Number))) {
                ColdSweat.LOGGER.error("Error parsing {} insulator config: invalid cold insulation value: {}", (Object)slot.getSerializedName(), entry.get(1));
                return null;
            }
            if (!(entry.get(2) instanceof Number || (obj = entry.get(2)) instanceof List && (list = (List)obj).stream().allMatch(val -> val instanceof Number))) {
                ColdSweat.LOGGER.error("Error parsing {} insulator config: invalid heat insulation valueL {}", (Object)slot.getSerializedName(), entry.get(2));
                return null;
            }
            List<Number> insulVal1 = entry.get(1) instanceof List ? (List<Number>)entry.get(1) : List.of((Number)entry.get(1));
            List<Number> insulVal2 = entry.get(2) instanceof List ? (List<Number>)entry.get(2) : List.of((Number)entry.get(2));
            List<Insulation> coldList = insulVal1.stream().map(val -> new StaticInsulation(val.doubleValue(), 0.0)).collect(Collectors.toList());
            List<Insulation> hotList = insulVal2.stream().map(val -> new StaticInsulation(0.0, val.doubleValue())).collect(Collectors.toList());
            insulation.addAll(Insulation.combine(coldList, hotList));
        } else {
            insulation.add(new AdaptiveInsulation(((Number)entry.get(1)).doubleValue(), ((Number)entry.get(2)).doubleValue()));
        }
        ItemComponentsRequirement components = entry.size() > 4 ? ItemComponentsRequirement.parse((String)entry.get(4)) : new ItemComponentsRequirement();
        boolean multiSlot = entry.size() > 5 && (Boolean)entry.get(5) != false;
        ItemRequirement itemRequirement = new ItemRequirement(items, components);
        return new InsulatorData(new NegatableList<ItemRequirement>(itemRequirement), slot, insulation, new NegatableList<EntityRequirement>(), new AttributeModifierMap(), new HashMap<ResourceLocation, Double>(), multiSlot);
    }

    public InsulatorData copy() {
        return new InsulatorData(this.item, this.slot, Insulation.deepCopy(this.insulation), this.entity, this.attributes, new HashMap<ResourceLocation, Double>(this.immuneTempModifiers), this.fillSlots);
    }

    public Codec<InsulatorData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InsulatorData that = (InsulatorData)obj;
        return super.equals(obj) && this.slot == that.slot && this.insulation.equals(that.insulation) && this.item.equals(that.item) && this.entity.equals(that.entity) && this.attributes.equals(that.attributes) && this.immuneTempModifiers.equals(that.immuneTempModifiers);
    }
}

