/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityClimateData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemCarryTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemInsulationSlotsData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.RemoveRegistryData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.util.math.FastMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ModRegistries {
    private static final Map<String, RegistryHolder<?>> REGISTRIES = new FastMap();
    public static final ResourceKey<Registry<InsulatorData>> INSULATOR_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/insulator")), InsulatorData.CODEC, InsulatorData.class);
    public static final ResourceKey<Registry<FuelData>> FUEL_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/fuel")), FuelData.CODEC, FuelData.class);
    public static final ResourceKey<Registry<FoodData>> FOOD_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/food")), FoodData.CODEC, FoodData.class);
    public static final ResourceKey<Registry<ItemCarryTempData>> CARRY_TEMP_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/carried_temp")), ItemCarryTempData.CODEC, ItemCarryTempData.class);
    public static final ResourceKey<Registry<DryingItemData>> DRYING_ITEM_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/drying_item")), DryingItemData.CODEC, DryingItemData.class);
    public static final ResourceKey<Registry<ItemInsulationSlotsData>> INSULATION_SLOTS_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/insulation_slots")), ItemInsulationSlotsData.CODEC, ItemInsulationSlotsData.class);
    public static final ResourceKey<Registry<BlockTempData>> BLOCK_TEMP_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"block/block_temp")), BlockTempData.CODEC, BlockTempData.class);
    public static final ResourceKey<Registry<BiomeTempData>> BIOME_TEMP_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"world/biome_temp")), BiomeTempData.CODEC, BiomeTempData.class);
    public static final ResourceKey<Registry<DimensionTempData>> DIMENSION_TEMP_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"world/dimension_temp")), DimensionTempData.CODEC, DimensionTempData.class);
    public static final ResourceKey<Registry<StructureTempData>> STRUCTURE_TEMP_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"world/structure_temp")), StructureTempData.CODEC, StructureTempData.class);
    public static final ResourceKey<Registry<DepthTempData>> DEPTH_TEMP_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"world/temp_region")), DepthTempData.CODEC, DepthTempData.class);
    public static final ResourceKey<Registry<MountData>> MOUNT_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"entity/mount")), MountData.CODEC, MountData.class);
    public static final ResourceKey<Registry<SpawnBiomeData>> ENTITY_SPAWN_BIOME_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"entity/spawn_biome")), SpawnBiomeData.CODEC, SpawnBiomeData.class);
    public static final ResourceKey<Registry<EntityTempData>> ENTITY_TEMP_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"entity/entity_temp")), EntityTempData.CODEC, EntityTempData.class);
    public static final ResourceKey<Registry<EntityClimateData>> ENTITY_CLIMATE_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"entity/climate")), EntityClimateData.CODEC, EntityClimateData.class);
    public static final ResourceKey<Registry<RemoveRegistryData<?>>> REMOVE_REGISTRY_DATA = ModRegistries.createRegistry(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"remove")), RemoveRegistryData.CODEC, null);

    public static <V extends ConfigData> ResourceKey<Registry<V>> createRegistry(ResourceKey<Registry<V>> registry, Codec<V> codec, Class<V> type) {
        REGISTRIES.put(registry.location().getPath(), new RegistryHolder<V>(registry, codec, type));
        return registry;
    }

    public static Map<String, RegistryHolder<?>> getRegistries() {
        return ImmutableMap.copyOf(REGISTRIES);
    }

    public static ResourceKey<Registry<? extends ConfigData>> getRegistry(String name) {
        return Optional.ofNullable(REGISTRIES.get(name)).map(holder -> holder.registry()).orElseThrow(() -> (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown Cold Sweat registry: " + name)));
    }

    public static <T> ResourceKey<Registry<T>> getRegistry(T object) {
        return REGISTRIES.values().stream().filter(holder -> holder.type.isInstance(object)).findFirst().map(RegistryHolder::registry).orElse(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"unknown")));
    }

    public static String getRegistryName(ResourceKey<? extends ConfigData> key) {
        return key.location().getPath();
    }

    public static <T extends ConfigData> Codec<T> getCodec(ResourceKey<Registry<T>> registry) {
        return Optional.of(REGISTRIES.get(ModRegistries.getRegistryName(registry))).map(RegistryHolder::codec).orElseThrow(() -> (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown Cold Sweat registry: " + registry.location().getPath())));
    }

    public record RegistryHolder<V extends ConfigData>(ResourceKey<Registry<V>> registry, Codec<V> codec, Class<V> type) {
    }
}

