/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncPreferredUnitsMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncPreferredUnitsMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"sync_preferred_units"));
    public static final StreamCodec<FriendlyByteBuf, SyncPreferredUnitsMessage> CODEC = CustomPacketPayload.codec(SyncPreferredUnitsMessage::encode, SyncPreferredUnitsMessage::decode);
    Temperature.Units units;

    public SyncPreferredUnitsMessage(Temperature.Units units) {
        this.units = units;
    }

    public static void encode(SyncPreferredUnitsMessage message, FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)message.units);
    }

    public static SyncPreferredUnitsMessage decode(FriendlyByteBuf buffer) {
        return new SyncPreferredUnitsMessage((Temperature.Units)buffer.readEnum(Temperature.Units.class));
    }

    public static void handle(SyncPreferredUnitsMessage message, IPayloadContext context) {
        context.enqueueWork(() -> EntityTempManager.getTemperatureCap((Entity)context.player()).ifPresent(cap -> cap.setPreferredUnits(message.units)));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

