/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.advancement.trigger;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ArmorInsulatedTrigger
extends SimpleCriterionTrigger<Instance> {
    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public void trigger(ServerPlayer player, ItemStack fuelStack, ItemStack lampStack) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(fuelStack, lampStack));
    }

    public record Instance(Optional<ContextAwarePredicate> player, ItemPredicate armorStack, ItemPredicate[] insulStack) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)ItemPredicate.CODEC.fieldOf("armor").forGetter(Instance::armorStack), (App)ItemPredicate.CODEC.listOf().xmap(list -> list.toArray(new ItemPredicate[0]), arr -> List.of(arr)).fieldOf("insulated").forGetter(Instance::insulStack)).apply((Applicative)instance, Instance::new));

        public boolean matches(ItemStack fuelStack, ItemStack lampStack) {
            return this.armorStack.test(fuelStack) && (this.insulStack.length == 0 || Arrays.stream(this.insulStack).anyMatch(predicate -> predicate.test(lampStack)));
        }
    }
}

