/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat;

import com.anthonyhilyard.iceberg.component.TitleBreakComponent;
import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.init.FetchSeasonsModsEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.compat.SereneSeasonsTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.compat.create.ColdSweatPonderPlugin;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.DivingHelmetItem;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import dev.ghen.thirst.content.purity.ContainerWithPurity;
import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.foundation.common.event.RegisterThirstValueEvent;
import glitchcore.event.EventManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import sereneseasons.season.SeasonHooks;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CompatManager {
    private static final boolean BOP_LOADED = CompatManager.modLoaded("biomesoplenty");
    private static final boolean SERENE_SEASONS_LOADED = CompatManager.modLoaded("sereneseasons");
    private static final boolean CURIOS_LOADED = CompatManager.modLoaded("curios");
    private static final boolean WEREWOLVES_LOADED = CompatManager.modLoaded("werewolves");
    private static final boolean SPIRIT_LOADED = CompatManager.modLoaded("spirit");
    private static final boolean BYG_LOADED = CompatManager.modLoaded("byg");
    private static final boolean BWG_LOADED = CompatManager.modLoaded("biomeswevegone");
    private static final boolean CREATE_LOADED = CompatManager.modLoaded("create", "6.0.0");
    private static final boolean ATMOSPHERIC_LOADED = CompatManager.modLoaded("atmospheric");
    private static final boolean ENVIRONMENTAL_LOADED = CompatManager.modLoaded("environmental");
    private static final boolean TERRALITH_LOADED = CompatManager.modLoaded("terralith");
    private static final boolean WEATHER_LOADED = CompatManager.modLoaded("weather2");
    private static final boolean WYTHERS_LOADED = CompatManager.modLoaded("wwoo");
    private static final boolean TOOLTIPS_LOADED = CompatManager.modLoaded("legendarytooltips");
    private static final boolean PRIMAL_WINTER_LOADED = CompatManager.modLoaded("primalwinter");
    private static final boolean THIRST_LOADED = CompatManager.modLoaded("thirst", "1.21.1-2.1.0");
    private static final boolean ICEBERG_LOADED = CompatManager.modLoaded("iceberg", "1.3.0");
    private static final boolean SPOILED_LOADED = CompatManager.modLoaded("spoiled");
    private static final boolean SUPPLEMENTARIES_LOADED = CompatManager.modLoaded("supplementaries");
    private static final boolean TOUGH_AS_NAILS_LOADED = CompatManager.modLoaded("toughasnails");
    private static final boolean TWILIGHT_FOREST_LOADED = CompatManager.modLoaded("twilightforest");
    private static final boolean AETHER_LOADED = CompatManager.modLoaded("aether");
    private static final List<String> SEASONS_MODS = CompatManager.fetchSeasonsMods();
    public static boolean USING_BACKTANK = false;

    public static boolean modLoaded(String modID, String minVersion, String maxVersion) {
        ModFileInfo mod = FMLLoader.getLoadingModList().getModFileById(modID);
        if (mod == null) {
            return false;
        }
        ArtifactVersion version = ((IModInfo)mod.getMods().get(0)).getVersion();
        if (!minVersion.isEmpty() && version.compareTo((Object)new DefaultArtifactVersion(minVersion)) < 0) {
            ColdSweat.LOGGER.error("Cold Sweat requires {} {} or higher for compat to be enabled! (found {})", (Object)modID, (Object)minVersion, (Object)version);
            return false;
        }
        if (!maxVersion.isEmpty() && version.compareTo((Object)new DefaultArtifactVersion(maxVersion)) > 0) {
            ColdSweat.LOGGER.error("Cold Sweat requires {} {} or lower for compat to be enabled! (found {})", (Object)modID, (Object)maxVersion, (Object)version);
            return false;
        }
        return true;
    }

    public static boolean modLoaded(String modID, String minVersion) {
        return CompatManager.modLoaded(modID, minVersion, "");
    }

    public static boolean modLoaded(String modID) {
        return CompatManager.modLoaded(modID, "");
    }

    private static List<String> fetchSeasonsMods() {
        FetchSeasonsModsEvent event = new FetchSeasonsModsEvent();
        if (SERENE_SEASONS_LOADED) {
            event.addSeasonsMod("sereneseasons");
        }
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getSeasonsMods();
    }

    public static List<String> getSeasonsMods() {
        return SEASONS_MODS;
    }

    public static boolean isBiomesOPlentyLoaded() {
        return BOP_LOADED;
    }

    public static boolean isSereneSeasonsLoaded() {
        return SERENE_SEASONS_LOADED;
    }

    public static boolean isCuriosLoaded() {
        return CURIOS_LOADED;
    }

    public static boolean isWerewolvesLoaded() {
        return WEREWOLVES_LOADED;
    }

    public static boolean isSpiritLoaded() {
        return SPIRIT_LOADED;
    }

    public static boolean isBiomesYoullGoLoaded() {
        return BYG_LOADED;
    }

    public static boolean isBiomesWeveGoneLoaded() {
        return BWG_LOADED;
    }

    public static boolean isCreateLoaded() {
        return CREATE_LOADED;
    }

    public static boolean isAtmosphericLoaded() {
        return ATMOSPHERIC_LOADED;
    }

    public static boolean isEnvironmentalLoaded() {
        return ENVIRONMENTAL_LOADED;
    }

    public static boolean isTerralithLoaded() {
        return TERRALITH_LOADED;
    }

    public static boolean isWeather2Loaded() {
        return WEATHER_LOADED;
    }

    public static boolean isWythersLoaded() {
        return WYTHERS_LOADED;
    }

    public static boolean isLegendaryTooltipsLoaded() {
        return TOOLTIPS_LOADED;
    }

    public static boolean isPrimalWinterLoaded() {
        return PRIMAL_WINTER_LOADED;
    }

    public static boolean isThirstLoaded() {
        return THIRST_LOADED;
    }

    public static boolean isIcebergLoaded() {
        return ICEBERG_LOADED;
    }

    public static boolean isSpoiledLoaded() {
        return SPOILED_LOADED;
    }

    public static boolean isSupplementariesLoaded() {
        return SUPPLEMENTARIES_LOADED;
    }

    public static boolean isToughAsNailsLoaded() {
        return TOUGH_AS_NAILS_LOADED;
    }

    public static boolean isTwilightForestLoaded() {
        return TWILIGHT_FOREST_LOADED;
    }

    public static boolean isAetherLoaded() {
        return AETHER_LOADED;
    }

    public static void registerEventHandlers() {
        if (CURIOS_LOADED) {
            NeoForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void onCurioChange(CurioChangeEvent event) {
                    EntityTempManager.updateInsulationAttributeModifiers(event.getEntity(), event.getFrom(), event.getTo());
                }
            });
        }
        if (THIRST_LOADED) {
            NeoForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void registerThirstItems(RegisterThirstValueEvent event) {
                    event.addDrink((Item)ModItems.FILLED_WATERSKIN.value(), 6, 3);
                    event.addContainer(new ContainerWithPurity((Item)ModItems.WATERSKIN.value(), (Item)ModItems.FILLED_WATERSKIN.value()));
                }
            });
        }
        if (SERENE_SEASONS_LOADED) {
            new Object(){

                public void registerListener() {
                    EventManager.addListener(event -> {
                        for (Player player : event.getLevel().players()) {
                            Temperature.getModifier((LivingEntity)player, Temperature.Trait.WORLD, SereneSeasonsTempModifier.class).ifPresent(mod -> mod.update(mod.getLastInput(Temperature.Trait.WORLD), (LivingEntity)player, Temperature.Trait.WORLD));
                        }
                    });
                }
            }.registerListener();
        }
    }

    @SubscribeEvent
    public static void drainCreateBacktank(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!CompatManager.isCreateLoaded()) {
            return;
        }
        ItemStack backTank = player.getItemBySlot(EquipmentSlot.CHEST);
        if (USING_BACKTANK && player.level().isClientSide) {
            player.getPersistentData().putInt("VisualBacktankAir", BacktankUtil.getAllWithAir((LivingEntity)player).stream().map(BacktankUtil::getAir).reduce(0, Integer::sum) - 1);
        }
        if (player.tickCount % 20 != 0) {
            return;
        }
        double worldTemp = Temperature.get((LivingEntity)player, Temperature.Trait.WORLD);
        double freezingPoint = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
        double burningPoint = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
        if (!player.isCreative() && !player.isInLava() && backTank.getItem() instanceof BacktankItem && backTank.has(DataComponents.FIRE_RESISTANT) && (ConfigSettings.HEAT_DRAINS_BACKTANK.get() != false && worldTemp > burningPoint || ConfigSettings.COLD_DRAINS_BACKTANK.get().booleanValue() && worldTemp < freezingPoint)) {
            ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
            if (!helmet.has(DataComponents.FIRE_RESISTANT) || !(helmet.getItem() instanceof DivingHelmetItem)) {
                return;
            }
            ItemStack boots = player.getItemBySlot(EquipmentSlot.FEET);
            if (!boots.has(DataComponents.FIRE_RESISTANT)) {
                return;
            }
            ItemStack pants = player.getItemBySlot(EquipmentSlot.LEGS);
            if (!pants.has(DataComponents.FIRE_RESISTANT)) {
                return;
            }
            if (player.level().isClientSide) {
                USING_BACKTANK = true;
            }
            if ((Integer)backTank.getOrDefault(AllDataComponents.BACKTANK_AIR, (Object)0) > 0) {
                BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)backTank, (int)1);
                if (player.level().isClientSide) {
                    player.getPersistentData().putInt("VisualBacktankAir", BacktankUtil.getAllWithAir((LivingEntity)player).stream().map(BacktankUtil::getAir).reduce(0, Integer::sum).intValue());
                }
            }
        } else if (player.level().isClientSide) {
            USING_BACKTANK = false;
        }
    }

    @EventBusSubscriber(modid="cold_sweat", bus=EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void setupModEvents(FMLCommonSetupEvent event) {
        }

        @SubscribeEvent
        public static void setupModClientEvents(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                if (CompatManager.isCreateLoaded()) {
                    new Object(){

                        public void registerPonderPlugin() {
                            PonderIndex.addPlugin((PonderPlugin)new ColdSweatPonderPlugin());
                        }
                    }.registerPonderPlugin();
                }
            });
        }
    }

    public static abstract class Valkyrien {
    }

    public static abstract class LegendaryTooltips {
        public static int getTooltipStartIndex(List<Either<FormattedText, TooltipComponent>> tooltip) {
            if (CompatManager.isIcebergLoaded()) {
                int index = CSMath.getIndexOf(tooltip, element -> element.right().map(component -> component instanceof TitleBreakComponent).orElse(false));
                if (index == -1) {
                    return 0;
                }
                return index;
            }
            return 0;
        }
    }

    public static abstract class Thirst {
        public static boolean hasWaterPurity(ItemStack stack) {
            if (THIRST_LOADED) {
                return WaterPurity.hasPurity((ItemStack)stack);
            }
            return false;
        }

        public static int getWaterPurity(final ItemStack stack) {
            if (THIRST_LOADED) {
                return new Object(){

                    public int getWaterPurity() {
                        return WaterPurity.getPurity((ItemStack)stack);
                    }
                }.getWaterPurity();
            }
            return 0;
        }

        public static ItemStack setWaterPurity(final ItemStack stack, final int purity) {
            if (THIRST_LOADED) {
                return new Object(){

                    public ItemStack setWaterPurity() {
                        return WaterPurity.addPurity((ItemStack)stack, (int)purity);
                    }
                }.setWaterPurity();
            }
            return stack;
        }

        public static ItemStack setWaterPurity(final ItemStack item, final BlockPos pos, final Level level) {
            if (THIRST_LOADED) {
                return new Object(){

                    public ItemStack setWaterPurity() {
                        return WaterPurity.addPurity((ItemStack)item, (BlockPos)pos, (Level)level);
                    }
                }.setWaterPurity();
            }
            return item;
        }
    }

    public static abstract class SereneSeasons {
        public static boolean isColdEnoughToSnow(Level level, BlockPos pos) {
            return SERENE_SEASONS_LOADED && SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, (Holder)level.getBiome(pos), (BlockPos)pos);
        }
    }

    public static abstract class Weather2 {
        public static boolean isRainstormAt(Level level, BlockPos pos) {
            return false;
        }

        public static Object getClosestStorm(Level level, BlockPos pos) {
            if (WEATHER_LOADED) {
                return null;
            }
            return null;
        }
    }

    public static abstract class Create {
        public static boolean isFluidPipe(BlockState state) {
            return CompatManager.isCreateLoaded() && (state.getBlock() instanceof FluidPipeBlock || state.getBlock() instanceof GlassFluidPipeBlock || state.getBlock() instanceof EncasedPipeBlock);
        }
    }

    public static abstract class Curios {
        public static boolean hasCurio(Player player, Item curio) {
            return CURIOS_LOADED && Optional.ofNullable((ICuriosItemHandler)player.getCapability(CuriosCapability.INVENTORY)).map(cap -> cap.findFirstCurio(curio)).map(Optional::isPresent).orElse(false) != false;
        }

        public static List<ItemStack> getCurios(LivingEntity entity) {
            if (!CURIOS_LOADED) {
                return new ArrayList<ItemStack>();
            }
            return Optional.ofNullable((ICuriosItemHandler)entity.getCapability(CuriosCapability.INVENTORY)).map(curiosHandler -> curiosHandler.getEquippedCurios()).map(stacks -> {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    list.add(stacks.getStackInSlot(i));
                }
                return list;
            }).orElse(new ArrayList());
        }
    }
}

