/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.world.feature;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.common.block.SoulStalkBlock;
import com.momosoftworks.coldsweat.common.world.feature.SoulStalkFeatureConfig;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;

public class SoulStalkFeature
extends Feature<SoulStalkFeatureConfig> {
    public SoulStalkFeature(Codec<SoulStalkFeatureConfig> config) {
        super(config);
    }

    public boolean isAirOrLeaves(WorldGenLevel level, BlockPos pos) {
        return level.getBlockState(pos).isAir() || level.getBlockState(pos).is(BlockTags.LEAVES);
    }

    public boolean place(FeaturePlaceContext<SoulStalkFeatureConfig> context) {
        SoulStalkFeatureConfig config = (SoulStalkFeatureConfig)context.config();
        WorldGenLevel level = context.level();
        BlockPos.MutableBlockPos pos = context.origin().mutable();
        int diskWidth = config.diskWidth();
        int diskHeight = config.diskHeight();
        RuleBasedBlockStateProvider diskProvider = config.diskStateProvider();
        BlockPredicate diskReplacer = config.replaceBlocks();
        int successes = 0;
        for (int t = 0; t < config.tries(); ++t) {
            pos.set((Vec3i)context.origin()).move(context.random().nextInt(config.spreadXZ()) - config.spreadXZ() / 2, context.random().nextInt(config.spreadY()) - config.spreadY() / 2, context.random().nextInt(config.spreadXZ()) - config.spreadXZ() / 2);
            int startY = pos.getY();
            int minHeight = level.getMinBuildHeight();
            int maxHeight = level.getMaxBuildHeight();
            for (int i = -10; i < 10; ++i) {
                pos.setY(startY + i);
                if (pos.getY() >= minHeight && (pos.getY() > maxHeight || level.getBlockState((BlockPos)pos).isAir())) break;
            }
            if (!level.getBlockState(pos.below()).is(ModBlockTags.SOUL_STALK_PLACEABLE_ON) && diskWidth > 0 && diskHeight > 0) {
                SoulStalkFeature.placeDisk(level, (BlockPos)pos, diskWidth, diskHeight, diskWidth, diskProvider, diskReplacer);
            }
            if (!level.getBlockState(pos.below()).is(ModBlockTags.SOUL_STALK_PLACEABLE_ON) || !level.getBlockState(pos.above()).isAir()) continue;
            level.setBlock((BlockPos)pos, ((Block)ModBlocks.SOUL_STALK.value()).defaultBlockState(), 2);
            int height = new Random().nextInt(5) + 2;
            for (int i = 0; i < height && this.isAirOrLeaves(level, pos.above()); ++i) {
                pos.move(0, 1, 0);
                level.setBlock((BlockPos)pos, (BlockState)((Block)ModBlocks.SOUL_STALK.value()).defaultBlockState().setValue(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.getRandomMidsection())), 2);
            }
            level.setBlock((BlockPos)pos, (BlockState)((Block)ModBlocks.SOUL_STALK.value()).defaultBlockState().setValue(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.Section.TOP)), 2);
            int minCount = config.minCount();
            int maxCount = config.maxCount();
            if (++successes >= maxCount || successes >= minCount && context.random().nextInt(0, maxCount - minCount) == 0) break;
        }
        return successes > 0;
    }

    private static void placeDisk(WorldGenLevel level, BlockPos pos, int radiusX, int radiusY, int radiusZ, RuleBasedBlockStateProvider diskProvider, BlockPredicate diskReplacer) {
        for (int x = -radiusX; x <= radiusX; ++x) {
            for (int y = -radiusY; y <= radiusY; ++y) {
                for (int z = -radiusZ; z <= radiusZ; ++z) {
                    BlockPos diskPos;
                    if (!(Math.pow((double)x / (double)radiusX, 2.0) + Math.pow((double)y / (double)radiusY, 2.0) + Math.pow((double)z / (double)radiusZ, 2.0) < 1.0) || !diskReplacer.test((Object)level, (Object)(diskPos = pos.offset(x, y, z)))) continue;
                    level.setBlock(diskPos, diskProvider.getState(level, level.getRandom(), diskPos), 2);
                }
            }
        }
    }
}

