/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ThermometerItem
extends Item {
    public ThermometerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (CompatManager.isSupplementariesLoaded() && !player.level().isClientSide) {
            Temperature.Units units = EntityTempManager.getTemperatureCap((Entity)player).map(cap -> cap.getPreferredUnits()).orElse(Temperature.Units.F);
            int temperature = (int)Temperature.convert(WorldHelper.getTemperatureAt(player.level(), player.blockPosition()), Temperature.Units.MC, units, true);
            player.displayClientMessage((Component)Component.literal((String)(temperature + " " + units.getFormattedName())), true);
            player.swing(hand, true);
        }
        return super.use(level, player, hand);
    }
}

