/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModAttributes;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class TempEffectsCommon {
    @SubscribeEvent
    public static void onPlayerMine(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (EntityTempManager.isPeacefulMode((LivingEntity)player)) {
            return;
        }
        float miningSpeed = 1.0f - ConfigSettings.COLD_MINING_IMPAIRMENT.get().floatValue();
        if (miningSpeed == 1.0f || player.hasEffect(ModEffects.ICE_RESISTANCE) || player.hasEffect(ModEffects.GRACE)) {
            return;
        }
        float temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
        if (temp < -50.0f) {
            float minMiningSpeed = (float)CSMath.blend((double)miningSpeed, 1.0, Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0);
            event.setNewSpeed(event.getNewSpeed() * CSMath.blend(minMiningSpeed, 1.0f, temp, -100.0f, -50.0f));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (EntityTempManager.isPeacefulMode((LivingEntity)player)) {
            return;
        }
        float temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
        if (temp < -50.0f) {
            float minMoveMultiplier;
            double movementReduction = ConfigSettings.COLD_MOVEMENT_SLOWDOWN.get();
            double movementSpeed = 1.0 - movementReduction;
            if (movementSpeed == 1.0 || player.hasEffect(ModEffects.ICE_RESISTANCE) || player.hasEffect(ModEffects.GRACE)) {
                return;
            }
            if (!player.isFallFlying() && (minMoveMultiplier = (float)CSMath.blend(player.onGround() ? movementSpeed : movementSpeed * 1.25, 1.0, Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0)) != 1.0f) {
                float moveSpeed = CSMath.blend(minMoveMultiplier, 1.0f, temp, -100.0f, -50.0f);
                player.setDeltaMovement(player.getDeltaMovement().multiply((double)moveSpeed, 1.0, (double)moveSpeed));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerKnockback(LivingKnockBackEvent event) {
        LivingEntity livingEntity = event.getEntity().getLastHurtByMob();
        if (livingEntity instanceof Player) {
            float liningProtFactor;
            Player player = (Player)livingEntity;
            if (EntityTempManager.isPeacefulMode((LivingEntity)player)) {
                return;
            }
            double knockbackReduction = ConfigSettings.COLD_KNOCKBACK_REDUCTION.get();
            if (knockbackReduction <= 0.0 || player.hasEffect(ModEffects.ICE_RESISTANCE) || player.hasEffect(ModEffects.GRACE)) {
                return;
            }
            float temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
            if (temp < -50.0f && (liningProtFactor = (float)CSMath.blend(1.0 - knockbackReduction, 1.0, Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0)) != 1.0f) {
                event.setStrength(event.getStrength() * CSMath.blend(liningProtFactor, 1.0f, temp, -100.0f, -50.0f));
            }
        }
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            float unfrozenHealth;
            Player player = (Player)livingEntity;
            if (EntityTempManager.isPeacefulMode((LivingEntity)player)) {
                return;
            }
            double frozenHeartsPercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
            if (frozenHeartsPercentage <= 0.0 || player.hasEffect(ModEffects.ICE_RESISTANCE) || player.hasEffect(ModEffects.GRACE)) {
                return;
            }
            float healing = event.getAmount();
            float temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
            if (temp < -50.0f && (unfrozenHealth = (float)CSMath.blend(1.0 - frozenHeartsPercentage, 1.0, Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0)) != 1.0f) {
                event.setAmount(CSMath.clamp(healing, 0.0f, (float)CSMath.ceil(player.getMaxHealth() * CSMath.blend(unfrozenHealth, 1.0f, temp, -100.0f, -50.0f)) - player.getHealth()));
            }
        }
    }

    public static int getTempResistance(Player player, boolean cold) {
        AttributeInstance tempAttribute;
        AttributeInstance attributeInstance = tempAttribute = cold ? player.getAttribute(ModAttributes.COLD_RESISTANCE) : player.getAttribute(ModAttributes.HEAT_RESISTANCE);
        if (tempAttribute == null) {
            return 0;
        }
        return (int)CSMath.blend(0.0, 4.0, tempAttribute.getValue(), 0.0, 1.0);
    }
}

