/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.event.vanilla.ChatComponentClickedEvent;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class SystemMessageHandler {
    private static MultiPlayerGameMode GAME_MODE = null;

    public static void onPlayerEnterCreative(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (Minecraft.getInstance().gameMode != GAME_MODE && Minecraft.getInstance().gameMode.getPlayerMode().isCreative() && ConfigSettings.SHOW_CREATIVE_WARNING.get().booleanValue() && !Minecraft.getInstance().isLocalServer()) {
            player.displayClientMessage((Component)SystemMessageHandler.getSystemPrefix().append((Component)Component.translatable((String)"message.cold_sweat.warning").append(" ").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED})).append((Component)Component.translatable((String)"message.cold_sweat.creative_warning_message").append(" ").withStyle(ChatFormatting.GRAY)).append((Component)Component.translatable((String)"message.cold_sweat.disable").withStyle(Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE).withClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, "cold sweat disable message")))), false);
            GAME_MODE = Minecraft.getInstance().gameMode;
        }
    }

    @SubscribeEvent
    public static void onPlayerClickChatMessage(ChatComponentClickedEvent event) {
        if (ConfigSettings.SHOW_CREATIVE_WARNING.get().booleanValue() && event.getStyle().getClickEvent() != null && event.getStyle().getClickEvent().getValue().equals("cold sweat disable message")) {
            ConfigSettings.SHOW_CREATIVE_WARNING.set(false);
            event.getPlayer().displayClientMessage((Component)SystemMessageHandler.getSystemPrefix().append((Component)Component.translatable((String)"message.cold_sweat.disable_feedback").withStyle(ChatFormatting.GRAY)), false);
        }
    }

    public static MutableComponent getSystemPrefix() {
        return Component.literal((String)"[").append((Component)Component.translatable((String)"message.cold_sweat.mod_name")).append("]: ").withStyle(ChatFormatting.LIGHT_PURPLE);
    }
}

